
@extends('admin.layout.main')
@section('content')
		<!-- GLOBAL-LOADER -->
		<div id="global-loader">
			<img src="../assets/images/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /GLOBAL-LOADER -->

		<!-- PAGE -->
			
                <!--app-content open-->
				<div class="app-content main-content">
					<div class="side-app">

						<div class="main-container">

						<!-- PAGE-HEADER -->
						<div class="page-header">
							<div>
								<h1 class="page-title">Update User</h1>
								<ol class="breadcrumb">
									<li class="breadcrumb-item"><a href="#">Main</a></li>
									<li class="breadcrumb-item active" aria-current="page">Update User</li>
								</ol>
							</div>
						</div>
						<!-- PAGE-HEADER END -->

						<!-- ROW-1 OPEN -->
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="card-title">Update User</div>
                                    </div>
                                    <div class="card-body">
                                        <form autocomplete="off" role="form" id="saveForm" action="{{route('admin.user.update')}}" method="POST" enctype="multipart/form-data">
                                        @csrf

                                            <div class="row mb-4">
                                                <input type="hidden" value="{{$user->id}}" name="id">
                                                <label class="col-md-3 form-label">User Name :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="name" class="form-control" value='{{old(' name') ?? $user->name}}' placeholder="User Name" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Email :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="email" class="form-control" value='{{old(' email') ?? $user->email}}' readonly>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Mobile :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="mobile" class="form-control" value='{{old('mobile') ?? $user->mobile}}' placeholder="Mobile" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Image :</label>
                                                <div class="col-md-9 file-upload">
                                                        <div class="col-md-9 file-select">
                                                            <input type="file" name="image" id="image" accept=".png, .jpg, .jpeg">
                                                            <div class="profile__image">
                                                                <img width="100px" height="100px" accept=".png, .jpg, .jpeg" name="old_image" class="upload-img" src="{{$user->photo}}" />
                                                            </div>
                                                        </div>
                                                </div>
                                            </div>
                                        
                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Status :</label>
                                                <div class="col-md-9">
                                                    <select name="status" class="form-control form-select select2" data-bs-placeholder="Select Status">
                                                        <option value="active" @if($user->status == 'active') selected="selected" @endif>Active</option>
                                                        <option value="in-active" @if($user->status == 'in-active') selected="selected" @endif>In-Active</option>
                                                </select>
                                                </div>
                                            </div>
                                    </div>

                                    <div class="card-footer">
                                        <!--Row-->
                                        <div class="row">
                                            <div class="col-md-3"></div>
                                            <div class="col-md-9">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                <a class="btn btn-default float-end" href='{{route('admin.user.list')}}'>
                                                    Close
                                                </a>
                                               
                                            </div>
                                        </div>
                                        <!--End Row-->
                                    </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- /ROW-1 CLOSED -->

					</div>
					<!-- CONTAINER CLOSED -->
				</div>
			</div>	
		<!-- </div> -->
@endsection
		