<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Controllers\API\BaseController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Ad;
use App\Models\WalletHistory;
use App\Models\User;
use App\Models\CardHistory;
use App\Models\Plan;
use App\Models\Pool;

class AdController extends BaseController
{
    public function list(Request $request) {
        $user = Auth::user();
        $today = date('Y-m-d');
        $getWalletHistory = WalletHistory::select('ad_id')->where('user_id',$user->id)->whereDate('date','=',$today)->where('title','watch_add')->get()->toArray();
      
        $data = Ad::whereNotIn('id',$getWalletHistory)->whereDate('date','=',$today)->where('status','=','active')->get()->toArray();
        return $this->sendResponse($data, 'Ad list get successfully!');
    }

    public function videoWatch(Request $request) {
       
        $input = $request->all();
        $validator = Validator::make($request->all(), [
            'video_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        $user = Auth::user();
        $video_data = Ad::where('id',$input['video_id'])->first();
  
        if(!empty($video_data)){

            $data = [
                'user_id' => $user->id,
                'ad_id' => $input['video_id'],
                'coin' => $video_data['coin'],
                'title'=> "watch_add",
                'display_text' => "Daily AD Reward",
                'type'=>"credited",
                'status'=>'success',
            ];
    
            $walletHistory = WalletHistory::create($data);

            //update wallet amount
            $walletAmount = $user['wallet_balance'] + $video_data['coin'];
            $update_wallet_balance = User::where('id',$user->id)->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
            return $this->sendResponse([$walletHistory], 'Claim successfully!');

        }else{
            return $this->sendError('Error', ['error'=>"Ad Not Found!"]);
        }
    }

    public function walletHistory(Request $request) {
        $user = Auth::user();
        $getWalletHistory = WalletHistory::where('user_id',$user->id)->orderBy('id','desc')->get()->toArray();
        
        foreach($getWalletHistory as $key=>$data){
            $getWalletHistory[$key]['date'] = date('d/m/Y',strtotime( $data['date']));
            
            if($data['plan_id'] != '0'){

                $plan = Plan::where('id',$data['plan_id'])->first();
                $souce_user_name = User::where('id',$data['source_id'])->first();

                $getWalletHistory[$key]['plan_name'] = $plan['title'];
                $getWalletHistory[$key]['souce_user_name'] = ucfirst($souce_user_name['name']);
                $getWalletHistory[$key]['pool_name'] = "";
            }else{
                $getWalletHistory[$key]['plan_name'] ="";
                $getWalletHistory[$key]['souce_user_name'] ="";
                $pool_name = Pool::where('id',$data['pools_id'])->first();
                
                if(!empty($pool_name)){
                    $p_name = $pool_name['name'];
                }else{
                    $p_name = "";
                }
                $getWalletHistory[$key]['pool_name'] = $p_name;
         
            }
        }
        return $this->sendResponse($getWalletHistory, 'History get successfully!');
    }

    public function cardHistory(Request $request) {

        $input = $request->all();
        // $validator = Validator::make($request->all(), [
        //     'plan_id' => 'required',
        // ]);

        // if ($validator->fails()) {
        //     return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        // }

        $user = Auth::user();
        if(isset($input['plan_id']) && $input['plan_id'] != ""){
          
            $getCardHistory = CardHistory::where('user_id',$user->id)->where('plan_id',$input['plan_id'])->where('status','=','active')->orderBy('id','desc')->get()->toArray();
            foreach($getCardHistory as $key=>$data){
                $plan = Plan::where('id',$data['plan_id'])->first();

                $getCardHistory[$key]['plan_price'] = $plan['coin'];
                $getCardHistory[$key]['created_at'] = date('d/m/Y',strtotime( $data['created_at']));
            }
        }else{
            $getPlan = CardHistory::where('user_id',$user->id)->where('status','=','active')->orderBy('id','ASC')->first();
            $getCardHistory = [];
            if(!empty($getPlan)){
                $getCardHistory = CardHistory::where('user_id',$user->id)->where('plan_id',$getPlan['plan_id'])->where('status','=','active')->orderBy('id','desc')->get()->toArray();
                foreach($getCardHistory as $key=>$data){
                    $plan = Plan::where('id',$data['plan_id'])->first();
    
                    $getCardHistory[$key]['plan_price'] = $plan['coin'];
                    $getCardHistory[$key]['created_at'] = date('d/m/Y',strtotime( $data['created_at']));
                }
            }
        }
        return $this->sendResponse($getCardHistory, 'Card History get successfully!');
    }

    public function planList(Request $request) {
        $getPlan = Plan::orderBy('id','asc')->get()->toArray();
        return $this->sendResponse($getPlan, 'Plan list get successfully!');
    }

    public function activePlan(Request $request) {
        $user = Auth::user();
        $getPurchaseHistory = CardHistory::where('user_id',$user->id)->where('status','=','active')->orderBy('id','ASC')->get()->toArray();
      
        foreach($getPurchaseHistory as $key=>$data){
            $plan = Plan::where('id',$data['plan_id'])->first();
            $getPurchaseHistory[$key]['plan_data'] = $plan;
        }
        return $this->sendResponse($getPurchaseHistory, 'Plan list get successfully!');

    }

    public function videoEarning(Request $request) {
        $user = Auth::user();
        $getWalletHistory = WalletHistory::where('title','=','watch_add')->where('type','=','credited')->where('user_id',$user->id)->orderBy('id','desc')->get()->toArray();
        foreach($getWalletHistory as $key=>$data){
            $getWalletHistory[$key]['date'] = date('d/m/Y',strtotime($data['date']));
        }
        return $this->sendResponse($getWalletHistory, 'History get successfully!');
    }

}
