<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Controllers\API\BaseController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use App\Models\Setting;
use App\Models\UserResetPassword;
use App\Models\WalletHistory;
use DateTime;

class AuthenticationController extends BaseController
{
    public function signUp(Request $request) {
      
        $input = $request->all();

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|unique:users',
            // 'mobile' => 'required|unique:users',
            'password' => 'required',
            // 'photo' => 'required',
            // 'referral_code' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }
        
        if(isset($input['referral_code']) && $input['referral_code'] != ""){
            $referral___input = $input['referral_code'];
            
            //check referral code is valid or not
            $ref_code = $referral___input;
            $get_ref_code = User::where('unique_id','=',$ref_code)->first();
            
            if(!empty($get_ref_code)){
            
                if(isset($input['photo'])) {
                    $file = $request->file('photo');
                    $destinationPath = storage_path() . '/app/public/user_profile/';
                    if (!is_dir($destinationPath)) {
        
                        /* Directory does not exist, so lets create it. */
                        mkdir($destinationPath, 0777);
                    }
                    $file_name = str_replace(' ', '_', $input['name']) . '_' . time() . '.' . ($input['photo'])->extension();
                    $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_name);
                    $file->move($destinationPath, $fileName);
                    $url = asset('storage/app/public/user_profile/' . $fileName);
                    $imageUrl = "$url";
                } else {
                    $imageUrl = null;
                }
        
                $referral =rand('10000000','99999999');
                $input['password'] = Hash::make($input['password']);
                $data = [
                    'name' => $input['name'],
                    'email'=>isset($input['email']) ? $input['email'] : null,
                    'mobile'=>isset($input['mobile']) ? $input['mobile'] : null,
                    'password'=>$input['password'], 
                    'photo'=>$imageUrl,
                    'unique_id'=>$referral,
                    'is_verify'=>'0',
                    'status'=>'active',
                ];
        
                $user = User::create($data);
                $success['id'] = $user->id;
                $success['device_token'] = $user->createToken('customerAuthToken')->accessToken;
                $success['name'] = $user->name;
                $success['email'] = $user->email;
                $success['mobile'] = $user->mobile;
                $success['photo'] = $user->photo;
                $response = array($success);
              
                $refer_from = $get_ref_code['id']; 
                $user_update =User::where('id', $user->id)->update(['refferal_from' => $refer_from]);
    
                //send verification code
                $otp = $this->generateRandomOPT('4');
                $user_reset_password = [
                    'user_id'     => $user->id,
                    'code'        => $otp,
                    'send_date'   => date('Y-m-d'),
                    'send_time'   => date('H:i:s')
                ];
    
                $userResetPassword = UserResetPassword::create($user_reset_password);
    
                $setting = Setting::where('config_key','=','smtp_host')->first();
                $setting_host = Setting::where('config_key','=','smtp_port')->first();
                $smtp_from = Setting::where('config_key','=','smtp_from')->first();
                $sender_title = Setting::where('config_key','=','sender_title')->first();
                $sender_password = Setting::where('config_key','=','smtp_pass')->first();
    
                $user_data = User::where('email','=',$user->email)->first();
               
                $config = array(
                    'driver'    => 'smtp',
                    // 'host'       => 'smtp.mailgun.org',
                    'host'       => $setting['config_value'],
                    'port'       => $setting_host['config_value'],
                    'from'       => array('address' =>$smtp_from['config_value'], 'name' => $sender_title['config_value']),
                    'username'   => $smtp_from['config_value'],
                    'password'   => $sender_password['config_value'],
                );
              
                \Config::set('mail', $config);
                
                \Mail::to($user->email)->send(new \App\Mail\UserSignupMail($user_data,$otp)); 
                return $this->sendResponse($user_data, 'We have e-mailed verification code to your email id!'); 
    
                // return $this->sendResponse($response, 'Signup successfully!');
            }else{
                return $this->sendError('Error', ['error'=>"Invalid Referral Code!"]);
            }
        
        }else{
            // $referral___input = "0";
            
            if(isset($input['photo'])) {
                    $file = $request->file('photo');
                    $destinationPath = storage_path() . '/app/public/user_profile/';
                    if (!is_dir($destinationPath)) {
        
                        /* Directory does not exist, so lets create it. */
                        mkdir($destinationPath, 0777);
                    }
                    $file_name = str_replace(' ', '_', $input['name']) . '_' . time() . '.' . ($input['photo'])->extension();
                    $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_name);
                    $file->move($destinationPath, $fileName);
                    $url = asset('storage/app/public/user_profile/' . $fileName);
                    $imageUrl = "$url";
                } else {
                    $imageUrl = null;
                }
        
                $referral =rand('10000000','99999999');
                $input['password'] = Hash::make($input['password']);
                $data = [
                    'name' => $input['name'],
                    'email'=>isset($input['email']) ? $input['email'] : null,
                    'mobile'=>isset($input['mobile']) ? $input['mobile'] : null,
                    'password'=>$input['password'], 
                    'photo'=>$imageUrl,
                    'unique_id'=>$referral,
                    'is_verify'=>'0',
                    'status'=>'active',
                ];
        
                $user = User::create($data);
                $success['id'] = $user->id;
                $success['device_token'] = $user->createToken('customerAuthToken')->accessToken;
                $success['name'] = $user->name;
                $success['email'] = $user->email;
                $success['mobile'] = $user->mobile;
                $success['photo'] = $user->photo;
                $response = array($success);
              
                $refer_from = 0; 
                $user_update =User::where('id', $user->id)->update(['refferal_from' => $refer_from]);
    
                //send verification code
                $otp = $this->generateRandomOPT('4');
                $user_reset_password = [
                    'user_id'     => $user->id,
                    'code'        => $otp,
                    'send_date'   => date('Y-m-d'),
                    'send_time'   => date('H:i:s')
                ];
    
                $userResetPassword = UserResetPassword::create($user_reset_password);
    
                $setting = Setting::where('config_key','=','smtp_host')->first();
                $setting_host = Setting::where('config_key','=','smtp_port')->first();
                $smtp_from = Setting::where('config_key','=','smtp_from')->first();
                $sender_title = Setting::where('config_key','=','sender_title')->first();
                $sender_password = Setting::where('config_key','=','smtp_pass')->first();
    
                $user_data = User::where('email','=',$user->email)->first();
               
                $config = array(
                    'driver'    => 'smtp',
                    // 'host'       => 'smtp.mailgun.org',
                    'host'       => $setting['config_value'],
                    'port'       => $setting_host['config_value'],
                    'from'       => array('address' =>$smtp_from['config_value'], 'name' => $sender_title['config_value']),
                    'username'   => $smtp_from['config_value'],
                    'password'   => $sender_password['config_value'],
                );
              
                \Config::set('mail', $config);
                
                \Mail::to($user->email)->send(new \App\Mail\UserSignupMail($user_data,$otp)); 
                return $this->sendResponse($user_data, 'We have e-mailed verification code to your email id!'); 
        }

    }

    public function signUp_code_verify(Request $request){
        $input = $request->all();
        $validator = Validator::make($request->all(), [
            'email' => 'required',
            'code' => 'required',
        ]);
 
        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        $email = $input['email'];
        $code  = $input['code'];

        $curDate = date('Y-m-d');
        $chekEmail = User::where('email',$input['email'])->first();

        if($chekEmail){
            $chek = UserResetPassword::where('user_id',$chekEmail['id'])->where('code',$code)->orderBy('id','desc')->first();
            if($chek) {

                if($chek['send_date'] != $curDate) {
                    return $this->sendError('Error', ['error'=>"Code is Expired!"]);
                }else if($chek['is_expired'] == 1) {
                    return $this->sendError('Error', ['error'=>"Code is Expired!"]);
                }else{
                    $upd = UserResetPassword::where('id', $chek['id'])->update(['is_expired' => "1"]);
                    $upd_user = User::where('id', $chekEmail['id'])->update(['is_verify' => "1"]);
                    return $this->sendResponse('success', 'Code Verification suucessfully!'); 
                }
    
            }else {
                return $this->sendError('Error', ['error'=>"Invalid Code!"]);
            }
        }else{
            return $this->sendError('Error', ['error'=>"Invalid email!"]);
        }
       
    }

    public function login(Request $request){
        $input = $request->all();
        $validator = Validator::make($request->all(), [
            'email' => 'required',
            'password' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        $credentials = ['email' => $request->email, 'password' => $request->password, 'is_verify' => '1'];
      
        if(Auth::guard('users')->attempt($credentials)){
            $customer = Auth::guard('users')->user();
            // $get_user = User::where('id',$customer['id'])->first();
     
            $success['token'] =  $customer->createToken('customerAuthToken')->accessToken;
            $success['user'] = $customer;
            
            return $this->sendResponse($success, 'Login successfully.');
        }else{
            return $this->sendError('Your email or password not match', ['error'=>'User identity not found']);                
        }  
    }

    public function getProfile(Request $request) {
        $input = $request->all();
        $validator = Validator::make($request->all(), [
            'user_id' => 'required',
        ]);
    
        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        $customer = User::where('id',$input['user_id'])->first();
        return $this->sendResponse([$customer], 'Profile get successfully!');
    }

    public function updateProfile(Request $request){
        $input = $request->all();

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'photo' => 'required',
                    
        ]);
        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        if(isset($input['photo'])) {
            $file = $request->file('photo');
            $destinationPath = storage_path() . '/app/public/user_profile/';
            if (!is_dir($destinationPath)) {

                /* Directory does not exist, so lets create it. */
                mkdir($destinationPath, 0777);
            }
            $file_name = str_replace(' ', '_', $input['name']) . '_' . time() . '.' . ($input['photo'])->extension();
            $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_name);
            $file->move($destinationPath, $fileName);
            $url = asset('storage/app/public/user_profile/' . $fileName);
            // $url = asset('storage/uploaded_media/' . $fileName);

            $imageUrl = "$url";
        } else {
            $user_data = Auth::user();
            $imageUrl = $user_data['photo'];
        }
     
    
        $user_id = Auth::user();
        $user = User::find($user_id['id']);
        $user->id = $user_id['id'];
        $user->name = $request->name;
        $user->photo = $imageUrl;
        $user->save();
        
        $success['id'] = $user->id;
        $success['name'] = $user->name;
        $success['mobile'] = $user->mobile;
        $success['email'] = $user->email;
        $success['photo'] = asset($user->photo);
        $success['status'] = $user->status;
        $response = array($success);
        return $this->sendResponse($response, 'Profile Updated!');
    }

    public function change_password(Request $request){

        $validator = Validator::make($request->all(), [
            'old_password' => 'required',
            'new_password' => 'required',
            'confirm_password' => 'required'
         ]);
 
         if ($validator->fails()) {
             return response()->json(['status' => false, 'error' => $validator->errors()], 403);
         }

         $user_id = Auth::user();
         $input = $request->all();

         $old_password = \Hash::make($input['old_password']);

        if(!Hash::check($request->old_password, auth()->user()->password)){
            return $this->sendError('Error', ['error'=>"Old password doesn't match!"]);
        }elseif($input['new_password'] != $input['confirm_password']){
            return $this->sendError('Error', ['error'=>"New password and confirm password doesn't match!"]);
        }else{
            $user= User::where('id', $user_id['id'])->first();
            $_new = $request->new_password;
            
            //Hash and update the new password
            $user->password = \Hash::make($_new);
            $user->update();
            return $this->sendResponse('success', 'Password reset succesfully!');
        }

    }

    public function forgot_password(Request $request){
        $input = $request->all();
        $validator = Validator::make($request->all(), [
            'email' => 'required',
        ]);
 
        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        // $user_id = Auth::user();
        $user_data = User::where('email','=',$input['email'])->first();
        $otp = $this->generateRandomOPT('4');
      
        if(!empty($user_data)){

            $user_reset_password = [
                'user_id'     => $user_data['id'],
                'code'        => $otp,
                'send_date'   => date('Y-m-d'),
                'send_time'   => date('H:i:s')
            ];

            $userResetPassword = UserResetPassword::create($user_reset_password);

            $setting = Setting::where('config_key','=','smtp_host')->first();
            $setting_host = Setting::where('config_key','=','smtp_port')->first();
            $smtp_from = Setting::where('config_key','=','smtp_from')->first();
            $sender_title = Setting::where('config_key','=','sender_title')->first();
            $sender_password = Setting::where('config_key','=','smtp_pass')->first();
            
            $config = array(
                'driver'    => 'smtp',
                // 'host'       => 'smtp.mailgun.org',
                'host'       => $setting['config_value'],
                'port'       => $setting_host['config_value'],
                'from'       => array('address' =>$smtp_from['config_value'], 'name' => $sender_title['config_value']),
                'username'   => $smtp_from['config_value'],
                'password'   => $sender_password['config_value'],
            );
          
            \Config::set('mail', $config);
            
            \Mail::to($user_data['email'])->send(new \App\Mail\UserForgotPasswordMail($user_data,$otp)); 
            return $this->sendResponse($user_data, 'We have e-mailed verification code to your email id!'); 

        }else{
            return $this->sendError('Error', ['error'=>"Invalid email!"]);
        }
    }

    public function email_verify(Request $request){
        $input = $request->all();
        $validator = Validator::make($request->all(), [
            'email' => 'required',
            'code' => 'required',
        ]);
 
        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        $email = $input['email'];
        $code  = $input['code'];

        $curDate = date('Y-m-d');
        $chekEmail = User::where('email',$input['email'])->first();

        if($chekEmail){
            $chek = UserResetPassword::where('user_id',$chekEmail['id'])->where('code',$code)->orderBy('id','desc')->first();
            if($chek) {

                if($chek['send_date'] != $curDate) {
                    return $this->sendError('Error', ['error'=>"Code is Expired!"]);
                }else if($chek['is_expired'] == 1) {
                    return $this->sendError('Error', ['error'=>"Code is Expired!"]);
                }else{
                    $upd = UserResetPassword::where('id', $chek['id'])->update(['is_expired' => "1"]);
                    return $this->sendResponse('success', 'Code Verification suucessfully!'); 
                }
    
            }else {
                return $this->sendError('Error', ['error'=>"Invalid Code!"]);
            }
        }else{
            return $this->sendError('Error', ['error'=>"Invalid email!"]);
        }
       
    }

    function generateRandomOPT($length){
        return rand('1000','9999');
		// return substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length/strlen($x)) )),1,$length);
	}

    public function reset_password(Request $request){

        $input = $request->all();
        $validator = Validator::make($request->all(), [
            'user_id' => 'required',
            'new_password' => 'required',
            'confirm_password' => 'required'
         ]);
 
         if ($validator->fails()) {
             return response()->json(['status' => false, 'error' => $validator->errors()], 403);
         }

         $user_id = User::where('id',$input['user_id'])->first();
         $input = $request->all();

        if($input['new_password'] != $input['confirm_password']){
            return $this->sendError('Error', ['error'=>"New password and confirm password doesn't match!"]);
        }else{
            $user= User::where('id', $user_id['id'])->first();
            $_new = $request->new_password;
            
            //Hash and update the new password
            $user->password = \Hash::make($_new);
            $user->update();
            return $this->sendResponse('success', 'Password reset succesfully!');
        }

    }

    public function resend_code(Request $request){
        $input = $request->all();
        $validator = Validator::make($request->all(), [
            'email' => 'required',
        ]);
 
        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        $email = $input['email'];
        $chekEmail = User::where('email',$input['email'])->first();

        if($chekEmail){

              //send verification code
              $otp = $this->generateRandomOPT('4');
              $user_reset_password = [
                  'user_id'     => $chekEmail['id'],
                  'code'        => $otp,
                  'send_date'   => date('Y-m-d'),
                  'send_time'   => date('H:i:s')
              ];
  
              $userResetPassword = UserResetPassword::create($user_reset_password);
  
              $setting = Setting::where('config_key','=','smtp_host')->first();
              $setting_host = Setting::where('config_key','=','smtp_port')->first();
              $smtp_from = Setting::where('config_key','=','smtp_from')->first();
              $sender_title = Setting::where('config_key','=','sender_title')->first();
              $sender_password = Setting::where('config_key','=','smtp_pass')->first();
  
              $user_data = User::where('email','=',$input['email'])->first();
             
              $config = array(
                  'driver'    => 'smtp',
                  // 'host'       => 'smtp.mailgun.org',
                  'host'       => $setting['config_value'],
                  'port'       => $setting_host['config_value'],
                  'from'       => array('address' =>$smtp_from['config_value'], 'name' => $sender_title['config_value']),
                  'username'   => $smtp_from['config_value'],
                  'password'   => $sender_password['config_value'],
              );
            
              \Config::set('mail', $config);
              
              \Mail::to($chekEmail['email'])->send(new \App\Mail\UserSignupMail($chekEmail,$otp)); 
              return $this->sendResponse([], 'We have e-mailed verification code to your email id!'); 

        }else{
            return $this->sendError('Error', ['error'=>"Invalid email!"]);
        }
       
    }

    public function deleteAccount(Request $request){
        $data = User::where('id',Auth::user()->id)->delete();
        return $this->sendResponse('success', 'Deleted succesfully!');
    }

    public function getUserWallet(Request $request){
        $user = Auth::user();
        $data = User::select('wallet_balance','wallet_update_date')->where('id',$user->id)->first();
        $data['wallet_update_date'] = $this->timeago($data['wallet_update_date']);
        return $this->sendResponse($data, 'Success!');
    }

    function timeago($timestamp) {
        $datetime1=new DateTime("now");
        $datetime2=date_create($timestamp);
        $diff=date_diff($datetime1, $datetime2);
        $timemsg='';
        if($diff->y > 0){
            $timemsg = 'Last Updated '. $diff->y .' year'. ($diff->y > 1?"'s":'');
    
        }
        else if($diff->m > 0){
         $timemsg = 'Last Updated '. $diff->m . ' month'. ($diff->m > 1?"'s":'');
        }
        else if($diff->d > 0){
         $timemsg = 'Last Updated '. $diff->d .' day'. ($diff->d > 1?"'s":'');
        }
        else if($diff->h > 0){
         $timemsg = 'Last Updated '. $diff->h .' hour'.($diff->h > 1 ? "'s":'');
        }
        else if($diff->i > 0){
         $timemsg = 'Last Updated '. $diff->i .' minute'. ($diff->i > 1?"'s":'');
        }
        else if($diff->s > 0){
         $timemsg = 'Last Updated '. $diff->s .' second'. ($diff->s > 1?"'s":'');
        }
    
        $timemsg = $timemsg.' ago';
        return $timemsg;
    }

    public function referral_user_list(Request $request){
        $user = Auth::user();
      
        $referred_users = User::where('refferal_from',$user->id)->get()->toArray();
     
        foreach($referred_users as $key=>$rf){
            $wallet_history = WalletHistory::where('title','=','referral_commision')->where('user_id',$user->id)->where('source_id',$rf['id'])->sum('coin');
            $referred_users[$key]['referral_amount'] = $wallet_history;
        }
        return $this->sendResponse($referred_users, 'User get successfully!');
    }

    public function updateFcmToken(Request $request){
        
        $validator = Validator::make($request->all(), [
            'fcm_token'=> 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json(['status' => false, 'message' => 'Invalid request', 'data' => [$validator->errors()]], 403);
        }
        
        try{
            $user_id = Auth::user()->id;
            $requestData = $request->all();

            $user = User::find($user_id);
            $user->fcm_token = $requestData['fcm_token'];
            $user->save();

            $response = [];

            return $this->sendResponse($response, 'Token updated');
        } catch (Exception $ex) {
            $success = [];
            return $this->sendError('Error during Update FCM token',$success);
        }
    }
}
