<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Controllers\API\BaseController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
// use Hexters\CoinPayment\CoinPayment;
use App\Models\Plan;
use App\Models\User;
use App\Models\CardHistory;
use App\Models\WalletHistory;
use GuzzleHttp\Client;
use Plisio\PlisioSdkLaravel\Payment;

class CoinPaymentController extends BaseController
{

    protected $client;
    protected $publicKey;
    protected $privateKey;

    public function __construct()
    {
        $this->client = new Client();
        // $this->publicKey = config('coinpayments.public_key');
        // $this->privateKey = config('coinpayments.private_key');

        $this->publicKey = env('COINPAYMENT_PUBLIC_KEY');
        $this->privateKey = env('COINPAYMENT_PRIVATE_KEY');
    }

    // public function createPayment()
    // {
    //     $client = new \GuzzleHttp\Client();
     
    //     $response = $this->client->post('https://www.coinpayments.net/api.php?version=1.0', [
    //         'form_params' => [
    //             'key' => env('COINPAYMENT_PUBLIC_KEY'),
    //             'currency' => 'BTC', // Replace with your desired cryptocurrency
    //             // 'HMAC' => 'eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJhdWQiOiIxIiwianRpIjoiZjU2YjUxYTNlMDA0YWQyNDgxYWY0ZGM0MWVmMGI3MjUyMzU0NzAxZjNjMWI3YzliNTAxYzg4YjM3YTkwZmIwZDIxZDIyNGNiYTlmZmEzYmIiLCJpYXQiOjE2OTM4OTkxNjUuNjA4MjUzLCJuYmYiOjE2OTM4OTkxNjUuNjA4MjU2LCJleHAiOjE3MjU1MjE1NjUuNjAyMzcxLCJzdWIiOiI2Iiwic2NvcGVzIjpbXX0.gmAe57Ydp15NZ4PzIy6KfCTUEbHiUZqS_BREIq1-FjnlNRo-CpmjrwEHMJPK12V1dyqNP75NpquYmLJUZqxEpPxZNYsHEbEVmQo6djDWR__yS48jAdMb4KtugoGJMhBrMz5j6rr09V7EwbH1bQfjbMrYh6YY3wX3ve5xU4Wfs71uhuNwgF0WzCbxy5Iam4hju0z0gcDiY-mI9Oh_avI8-VOB872qEdAa1wpy7yBJALoKfFQrXPS_GrL6cEutit4sNbGLPqe2e4sejO9BsmJ7AfrYYmvkzExFONMbscAvvcg1DmFyi_Yqd8tqOcE1nIrk4RFgKo1JwSWswgMt3fVfFiHMYiCpPRmPJfxXh-zN-EvnXWLaQp8MVR3jKGhgoa5ejoOZJfcR1lylPfcmZIMl97_LXCJTN9EtlilJur155b3J8cNWfe7nojYqP6HkeJX4ee6y7h2YJ9T_qDrHKvRYjh84QNCWeEZD_hAOmVW9JEQSsNA1UztfP1TH0eIbXgZzLFbMM4T4LEk6SUMCPTkkYgfBPaBjEBCmixcwx30_gAZ0LxAOukZdTWZOMo9_tfbwcJtsbs0ohIgnTBH7hgY3ivkyJOgZH9ZdVge3d4soVdrnWQ-ZG93mtDljD9Zjze1BTgL7pU2-FrfPTvP25H8nKO1Ge7ITMTsReIF-1rt4kJk',
    //             'HMAC' => '106040501C2c772f5927baaCeC7fe717CD33d4BB5e9B8fac090371ff2035504c',
    //             // 'version' => '1',
    //             // Add any additional parameters as needed
    //         ],
    //         'headers' => [
    //             'HMAC' => 'sdsds',
    //             'version' => '1.0',
    //         ],
    //     ]);

    //     $data = json_decode($response->getBody(), true);
    
    //     // Handle the response data and return the address
    //     // $address = $data['result']['address'];

    //     // return $this->sendResponse($address, 'Successfully!');

    //     print_r($data);die;

    //     // return view('coinpayments.generate_address', compact('address'));
        
    //         // $txn_id = "102563";
    //         // $curl = curl_init();
    //         // $fields = array("txn_id" => $txn_id, "version" => "1.0");
    //         // curl_setopt_array($curl, array(
    //         //     CURLOPT_URL => "https://www.coinpayments.net/api.php",
    //         //     CURLOPT_RETURNTRANSFER => true,
    //         //     CURLOPT_CUSTOMREQUEST => "POST",
    //         //     CURLOPT_POSTFIELDS => $fields,
    //         //     CURLOPT_HTTPHEADER => array(
    //         //         "cache-control: no-cache",
    //         //         "content-type: application/json",
    //         //         "HMAC: sasas",
    //         //     ),
    //         // ));

    //         // $response = curl_exec($curl);
    //         // $err = curl_error($curl);
    //         // curl_close($curl);

    //         // if ($err) {
    //         // echo "cURL Error #:" . $err;
    //         // } else {
    //         // print_r($response);
    //         // }
    // }

    // public function createPayment(){
    //     // Replace with your CoinPayments API endpoint
    //     $apiUrl = 'https://www.coinpayments.net/api.php';

    //     // Set up your payload
    //     $payload = [
    //         'key' => env('COINPAYMENT_PUBLIC_KEY'),
    //         'cmd' => '_pay_simple',
    //         'amount' => 10.00, // Replace with the desired amount
    //         'currency' => 'BTC', // Replace with the desired currency
    //         'receiver' => 'sdsdsd', // Replace with your cryptocurrency address
    //         'item_name' => 'Example Payment',
    //         // 'HMAC' => "106040501C2c772f5927baaCeC7fe717CD33d4BB5e9B8fac090371ff2035504c"
    //         // 'ipn_url' => route('coinpayments.ipn'), // Optional: Set up an IPN route
    //     ];

    //     // print_r($payload);die;

    //     $headers = [
    //         "Content-Type" => "application/json", 
    //         'HMAC'=> '106040501C2c772f5927baaCeC7fe717CD33d4BB5e9B8fac090371ff2035504c', 
    //         'version'=> "1"
    //         // "HMAC"=> "106040501C2c772f5927baaCeC7fe717CD33d4BB5e9B8fac090371ff2035504c",
    //         // "Authorization" => "Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJhdWQiOiIxIiwianRpIjoiZjU2YjUxYTNlMDA0YWQyNDgxYWY0ZGM0MWVmMGI3MjUyMzU0NzAxZjNjMWI3YzliNTAxYzg4YjM3YTkwZmIwZDIxZDIyNGNiYTlmZmEzYmIiLCJpYXQiOjE2OTM4OTkxNjUuNjA4MjUzLCJuYmYiOjE2OTM4OTkxNjUuNjA4MjU2LCJleHAiOjE3MjU1MjE1NjUuNjAyMzcxLCJzdWIiOiI2Iiwic2NvcGVzIjpbXX0.gmAe57Ydp15NZ4PzIy6KfCTUEbHiUZqS_BREIq1-FjnlNRo-CpmjrwEHMJPK12V1dyqNP75NpquYmLJUZqxEpPxZNYsHEbEVmQo6djDWR__yS48jAdMb4KtugoGJMhBrMz5j6rr09V7EwbH1bQfjbMrYh6YY3wX3ve5xU4Wfs71uhuNwgF0WzCbxy5Iam4hju0z0gcDiY-mI9Oh_avI8-VOB872qEdAa1wpy7yBJALoKfFQrXPS_GrL6cEutit4sNbGLPqe2e4sejO9BsmJ7AfrYYmvkzExFONMbscAvvcg1DmFyi_Yqd8tqOcE1nIrk4RFgKo1JwSWswgMt3fVfFiHMYiCpPRmPJfxXh-zN-EvnXWLaQp8MVR3jKGhgoa5ejoOZJfcR1lylPfcmZIMl97_LXCJTN9EtlilJur155b3J8cNWfe7nojYqP6HkeJX4ee6y7h2YJ9T_qDrHKvRYjh84QNCWeEZD_hAOmVW9JEQSsNA1UztfP1TH0eIbXgZzLFbMM4T4LEk6SUMCPTkkYgfBPaBjEBCmixcwx30_gAZ0LxAOukZdTWZOMo9_tfbwcJtsbs0ohIgnTBH7hgY3ivkyJOgZH9ZdVge3d4soVdrnWQ-ZG93mtDljD9Zjze1BTgL7pU2-FrfPTvP25H8nKO1Ge7ITMTsReIF-1rt4kJk"
    //     ];


    //     // Create a Guzzle HTTP client and send the request
    //     $client = new Client();
    
    //     $response = $client->post($apiUrl, ['headers'=>$headers], ['form_params' => $payload]);
    //     // print_r($response->getBody());die;

    //     // Process the CoinPayments API response here
    //     $data = json_decode($response->getBody(), false);
    //     // $resp_data = $response->getBody();
    //     // print_r($data);die;

    //     return $this->sendResponse($data, 'Successfully!');

    // }

    // public function generateQRCode()
    // {
    //     // Replace 'coin_payment_url' with the actual URL for coin payment.
    //     $coinPaymentUrl = 'https://your-coin-payment-url.com';

    //     // Generate the QR code.
    //     QrCode::size(300)->generate($coinPaymentUrl);

    //     // You can return a view to display the QR code or do whatever you need with it.
    //     return view('coin_payment.qr_code', compact('coinPaymentUrl'));
    // }

    // public function createPayment()
    // {
    //     // $coinPayment = new CoinPayment();
    //     // $amount = 10; // Replace with your desired amount
    //     // $currency = 'USD'; // Replace with your desired currency
    //     // $payment = $coinPayment->createTransactionSimple($amount, $currency, 'unique_invoice_id');
        
    //     // // Redirect the user to the payment page
    //     // return redirect($payment['result']['status_url']);

    //     $transaction['order_id'] = uniqid(); // invoice number
    //     $transaction['amountTotal'] = (FLOAT) 37.5;
    //     $transaction['note'] = 'Transaction note';
    //     $transaction['buyer_name'] = 'Jhone Due';
    //     $transaction['buyer_email'] = 'buyer@mail.com';
    //     $transaction['redirect_url'] = url('/back_to_tarnsaction'); // When Transaction was comleted
    //     $transaction['cancel_url'] = url('/back_to_tarnsaction'); // When user click cancel link


    //     /*
    //     *   @required true
    //     *   @example first item
    //     */
    //     $transaction['items'][] = [
    //         'itemDescription' => 'Product one',
    //         'itemPrice' => (FLOAT) 7.5, // USD
    //         'itemQty' => (INT) 1,
    //         'itemSubtotalAmount' => (FLOAT) 7.5 // USD
    //     ];

    //     /*
    //     *   @example second item
    //     */
    //     $transaction['items'][] = [
    //         'itemDescription' => 'Product two',
    //         'itemPrice' => (FLOAT) 10, // USD
    //         'itemQty' => (INT) 1,
    //         'itemSubtotalAmount' => (FLOAT) 10 // USD
    //     ];

    //     /*
    //     *   @example third item
    //     */
    //     $transaction['items'][] = [
    //         'itemDescription' => 'Product Three',
    //         'itemPrice' => (FLOAT) 10, // USD
    //         'itemQty' => (INT) 2,
    //         'itemSubtotalAmount' => (FLOAT) 20 // USD
    //     ];

    //     $transaction['payload'] = [
    //         'foo' => [
    //             'bar' => 'baz'
    //         ]
    //     ];

    //     $link = CoinPayment::generatelink($transaction);

    //     return $this->sendResponse($link, 'Success!'); 

    //     // return redirect($link);


    // }

    // public function createPayment()
    // {
    //     $coinPayment = new CoinPayment();
    //     $amount = 10; // Replace with your desired amount
    //     $currency = 'USD'; // Replace with your desired currency
    //     $payment = $coinPayment->createTransactionSimple($amount, $currency, 'unique_invoice_id');
        
    //     // Redirect the user to the payment page
    //     return redirect($payment['result']['status_url']);
    // }

    // public function handleCallback(Request $request)
    // {
    //     $coinPayment = new CoinPayment();
    //     $payload = $request->all();
        
    //     // Verify the callback data with HexaX
    //     $verify = $coinPayment->verifyTransaction($payload);

    //     if ($verify === true) {
    //         // Payment is valid, process it accordingly
    //         // Update your database, deliver products, etc.
    //         // Return a response to HexaX to confirm receipt
    //         return 'Payment Successful';
    //     } else {
    //         // Payment failed or is not valid
    //         return 'Payment Failed';
    //     }
    // }

    // public function createPayment(){
    //     $transaction['order_id'] = uniqid(); // invoice number
    //     $transaction['amountTotal'] = (FLOAT) 37.5;
    //     $transaction['note'] = 'Transaction note';
    //     $transaction['buyer_name'] = 'Jhone Due';
    //     $transaction['buyer_email'] = 'buyer@mail.com';
    //     $transaction['redirect_url'] = url('/back_to_tarnsaction'); // When Transaction was comleted
    //     $transaction['cancel_url'] = url('/back_to_tarnsaction'); // When user click cancel link
      
      
    //     /*
    //     *   @required true
    //     *   @example first item
    //     */
    //     $transaction['items'][] = [
    //       'itemDescription' => 'Product one',
    //       'itemPrice' => (FLOAT) 7.5, // USD
    //       'itemQty' => (INT) 1,
    //       'itemSubtotalAmount' => (FLOAT) 7.5 // USD
    //     ];
      
    //     /*
    //     *   @example second item
    //     */
    //     $transaction['items'][] = [
    //       'itemDescription' => 'Product two',
    //       'itemPrice' => (FLOAT) 10, // USD
    //       'itemQty' => (INT) 1,
    //       'itemSubtotalAmount' => (FLOAT) 10 // USD
    //     ];
      
    //     /*
    //     *   @example third item
    //     */
    //     $transaction['items'][] = [
    //       'itemDescription' => 'Product Three',
    //       'itemPrice' => (FLOAT) 10, // USD
    //       'itemQty' => (INT) 2,
    //       'itemSubtotalAmount' => (FLOAT) 20 // USD
    //     ];
      
    //     $transaction['payload'] = [
    //       'foo' => [
    //           'bar' => 'baz'
    //       ]
    //     ];

    //     $response_data = CoinPayment::generatelink($transaction);
    //     return $this->sendResponse($response_data, 'Successfully!');
     
    // }

    // public function plan_purchase(Request $request){

    //     $input = $request->all();

    //     $validator = Validator::make($request->all(), [
    //         'plan_id' => 'required',
    //     ]);

    //     if ($validator->fails()) {
    //         return response()->json(['status' => false, 'error' => $validator->errors()], 403);
    //     }

    //     $get_plan_data = Plan::where('id',$input['plan_id'])->first();

    //     //check referrered user count
    //     $user = Auth::user();

    //     //get referral user
    //     $get_ref_user_name = User::where('id',$user['refferal_from'])->first();
    //     $get_ref_user_list = User::where('refferal_from',$get_ref_user_name['id'])->get()->toArray();
   
    //     if(count($get_ref_user_list) > 5){

    //         //add referral commision to user account
    //         $get_ref_user = User::where('refferal_from',$get_ref_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
    
    //         foreach($get_ref_user as $r_data){
    //             if($r_data['id'] == $user->id){

    //                 $amount = ($get_plan_data['coin']*30)/100;
             
    //                 //update wallet amount
    //                 $walletAmount = $get_ref_user_name['wallet_balance'] + $amount;
    //                 $update_wallet_balance = User::where('id',$get_ref_user_name['id'])->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);

    //                 //add wallet history
    //                 $wallet_history = [
    //                     'user_id' => $get_ref_user_name['id'],
    //                     'source_id' => $r_data['id'],
    //                     'plan_id' => $input['plan_id'],
    //                     'coin' => $amount,
    //                     'title' => 'referral_commision',
    //                     'display_text' => "Referral Commision",
    //                     'type' => 'credited'
    //                 ];
    //                 $referral_history = WalletHistory::create($wallet_history);
    //             }
    //         }
    //     }
     
    //     //create purchase history
    //     $ed = '+'.$get_plan_data['days'].' days';
    //     $expiry_date = date('Y-m-d', strtotime($ed));
    //     $data = [
    //         'user_id'=>$user->id,
    //         'plan_id'=>$input['plan_id'],
    //         'title'=>"plan_purchase",
    //         'display_text'=>"Plan Purchase",
    //         'activated_date'=>date('Y-m-d'),
    //         'expiry_date'=>$expiry_date,
    //         'status'=>'active'
    //     ];

    //     $plan_history = CardHistory::create($data);
    //     return $this->sendResponse($plan_history, 'Plan purchase successfully!'); 
    // }

    // public function plan_purchase_working(Request $request){

    //     $input = $request->all();

    //     $validator = Validator::make($request->all(), [
    //         'plan_id' => 'required',
    //     ]);

    //     if ($validator->fails()) {
    //         return response()->json(['status' => false, 'error' => $validator->errors()], 403);
    //     }

    //     $get_plan_data = Plan::where('id',$input['plan_id'])->first();

    //     //check referrered user count
    //     $user = Auth::user();
  
    //     //get first level referral user
    //     $get_ref_user_name = User::where('id',$user['refferal_from'])->first();
    //     $get_ref_user_list = User::where('refferal_from',$get_ref_user_name['id'])->get()->toArray();
        
    //     $get_ref_user_firt = User::where('refferal_from',$get_ref_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
      
    //     //get second level referral user
    //     // $get_second_level_user_name = User::where('id',$get_ref_user_name['refferal_from'])->first();
    //     // $get_second_ref_user_list = User::where('refferal_from',$get_second_level_user_name['id'])->get()->toArray();
    

    //     //get third level referral user
    //     // $get_third_level_user_name = User::where('id',$get_second_level_user_name['refferal_from'])->first();
    //     // $get_third_ref_user_list = User::where('refferal_from',$get_third_level_user_name['id'])->get()->toArray();
        

    //     //main user referral commision
    //     // if(count($get_ref_user_list) > 5){

    //         if(!empty($get_ref_user_firt)){
    //             foreach($get_ref_user_firt as $rf_data){
    //                 if($rf_data['id'] == $user->id){

    //                     $amount = ($get_plan_data['coin']*30)/100;
                
    //                     //update wallet amount
    //                     $walletAmount = $get_ref_user_name['wallet_balance'] + $amount;
    //                     $update_wallet_balance = User::where('id',$get_ref_user_name['id'])->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);

    //                     //add wallet history
    //                     $wallet_history = [
    //                         'user_id' => $get_ref_user_name['id'],
    //                         'source_id' => $rf_data['id'],
    //                         'plan_id' => $input['plan_id'],
    //                         'coin' => $amount,
    //                         'title' => 'referral_commision',
    //                         'display_text' => "Referral Commision",
    //                         'type' => 'credited'
    //                     ];
    //                     $referral_history = WalletHistory::create($wallet_history);
    //                 }
    //             }
    //         }

    //         if(!empty($get_ref_user_name) && !empty($get_ref_user_firt)){

    //             $get_second_level_user_name = User::where('id',$get_ref_user_name['refferal_from'])->first();
    //             $get_second_ref_user_list = User::where('refferal_from',$get_second_level_user_name['id'])->get()->toArray();
                
    //             $get_ref_user_second = User::where('refferal_from',$get_second_level_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
             
    //             if(!empty($get_ref_user_second)){
    //                 // foreach($get_ref_user_second as $rs_data){
                        
    //                     $second_user = User::where('id',$get_ref_user_second[0]['refferal_from'])->first();
    //                     $amount_second = ($get_plan_data['coin']*10)/100;
                
    //                     //update wallet amount
    //                     $walletAmount_second = $second_user['wallet_balance'] + $amount_second;
    //                     $update_wallet_balance = User::where('id',$second_user['id'])->update(['wallet_balance'=>$walletAmount_second, 'wallet_update_date'=>date("Y-m-d h:i:s")]);

    //                     //add wallet history
    //                     $wallet_history_second = [
    //                         'user_id' => $get_ref_user_second[0]['refferal_from'],
    //                         'source_id' => $user->id,
    //                         'plan_id' => $input['plan_id'],
    //                         'coin' => $amount_second,
    //                         'title' => 'referral_commision',
    //                         'display_text' => "Referral Commision",
    //                         'type' => 'credited'
    //                     ];
    //                     $referral_history = WalletHistory::create($wallet_history_second);
    //                 // }
    //             }

    //             if(!empty($get_second_level_user_name) && !empty($get_ref_user_second)){
    //                 $get_third_level_user_name = User::where('id',$get_second_level_user_name['refferal_from'])->first();
    //                 $get_third_ref_user_list = User::where('refferal_from',$get_third_level_user_name['id'])->get()->toArray();
                
    //                 $get_ref_user_third = User::where('refferal_from',$get_third_level_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
                 
    //                 if(!empty($get_ref_user_third)){
    //                     // foreach($get_ref_user_third as $r_data){

    //                         $third_user = User::where('id',$get_ref_user_third[0]['refferal_from'])->first();
    //                         $amount = ($get_plan_data['coin']*5)/100;
                            
    //                         //update wallet amount
    //                         $walletAmount = $third_user['wallet_balance'] + $amount;
    //                         $update_wallet_balance = User::where('id',$third_user['id'])->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
    
    //                         //add wallet history
    //                         $wallet_history = [
    //                             'user_id' => $third_user['id'],
    //                             'source_id' => $user->id,
    //                             'plan_id' => $input['plan_id'],
    //                             'coin' => $amount,
    //                             'title' => 'referral_commision',
    //                             'display_text' => "Referral Commision",
    //                             'type' => 'credited'
    //                         ];
    //                         $referral_history = WalletHistory::create($wallet_history);
                          
    //                     // }

    //                 }
    //             }
                
    //             //add referral commision to user account
    //             // $get_ref_user = User::where('refferal_from',$get_third_level_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();

    //             // if(!empty($get_ref_user)){
    //             //     foreach($get_ref_user as $r_data){
    //             //         if($r_data['id'] == $user->id){
    
    //             //             $amount = ($get_plan_data['coin']*30)/100;
                    
    //             //             //update wallet amount
    //             //             $walletAmount = $get_third_level_user_name['wallet_balance'] + $amount;
    //             //             $update_wallet_balance = User::where('id',$get_third_level_user_name['id'])->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
    
    //             //             //add wallet history
    //             //             $wallet_history = [
    //             //                 'user_id' => $get_ref_user_name['id'],
    //             //                 'source_id' => $r_data['id'],
    //             //                 'plan_id' => $input['plan_id'],
    //             //                 'coin' => $amount,
    //             //                 'title' => 'referral_commision',
    //             //                 'display_text' => "Referral Commision",
    //             //                 'type' => 'credited'
    //             //             ];
    //             //             $referral_history = WalletHistory::create($wallet_history);
    //             //         }
    //             //     }
    //             // }
    //         }

    //     // }


    //     //single referral commision flow
    //     // if(count($get_ref_user_list) > 5){

    //     //     //add referral commision to user account
    //     //     $get_ref_user = User::where('refferal_from',$get_ref_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
            
    //     //     foreach($get_ref_user as $r_data){
    //     //         if($r_data['id'] == $user->id){

    //     //             $amount = ($get_plan_data['coin']*30)/100;
             
    //     //             //update wallet amount
    //     //             $walletAmount = $get_ref_user_name['wallet_balance'] + $amount;
    //     //             $update_wallet_balance = User::where('id',$get_ref_user_name['id'])->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);

    //     //             //add wallet history
    //     //             $wallet_history = [
    //     //                 'user_id' => $get_ref_user_name['id'],
    //     //                 'source_id' => $r_data['id'],
    //     //                 'plan_id' => $input['plan_id'],
    //     //                 'coin' => $amount,
    //     //                 'title' => 'referral_commision',
    //     //                 'display_text' => "Referral Commision",
    //     //                 'type' => 'credited'
    //     //             ];
    //     //             $referral_history = WalletHistory::create($wallet_history);
    //     //         }
    //     //     }

    //     // }

    //     //create purchase history
    //     $ed = '+'.$get_plan_data['days'].' days';
    //     $expiry_date = date('Y-m-d', strtotime($ed));
    //     $data = [
    //         'user_id'=>$user->id,
    //         'plan_id'=>$input['plan_id'],
    //         'title'=>"plan_purchase",
    //         'display_text'=>"Plan Purchase",
    //         'activated_date'=>date('Y-m-d'),
    //         'expiry_date'=>$expiry_date,
    //         'status'=>'active'
    //     ];

    //     $plan_history = CardHistory::create($data);
    //     return $this->sendResponse($plan_history, 'Plan purchase successfully!'); 
    // }

    public function plan_purchase(Request $request){

        $input = $request->all();

        $validator = Validator::make($request->all(), [
            'plan_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        //check referrered user count
        $user = Auth::user();
       
        $get_plan_data = Plan::where('id',$input['plan_id'])->first();
        $purchased_CardHistory = CardHistory::where('user_id',$user->id)->where('plan_id',$get_plan_data['id'])->first();
        
        if(!empty($purchased_CardHistory)){
            $expiry_date = $purchased_CardHistory['expiry_date'];
        }else{
           $expiry_date = ""; 
        }
        $today = date('Y-m-d');
    
        if($expiry_date < $today){
           
            if($user['wallet_balance'] >= $get_plan_data['coin']){
               
                //get first level referral user
                $get_ref_user_name = User::where('id',$user['refferal_from'])->first();
                
                if(!empty($get_ref_user_name)){
                    $get_ref_user_list = User::where('refferal_from',$get_ref_user_name['id'])->get()->toArray();
                    
                    $get_ref_user_firt = User::where('refferal_from',$get_ref_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
                }else{
                    $get_ref_user_firt = "";
                }
                    
            
                //main user referral commision
                if(!empty($get_ref_user_firt)){
                    foreach($get_ref_user_firt as $rf_data){
                        if($rf_data['id'] == $user->id){
    
                            $amount = ($get_plan_data['coin']*30)/100;
                    
                            //update wallet amount
                            $walletAmount = $get_ref_user_name['wallet_balance'] + $amount;
                            $update_wallet_balance = User::where('id',$get_ref_user_name['id'])->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
    
                            //add wallet history
                            $wallet_history = [
                                'user_id' => $get_ref_user_name['id'],
                                'source_id' => $rf_data['id'],
                                'plan_id' => $input['plan_id'],
                                'coin' => $amount,
                                'title' => 'referral_commision',
                                'display_text' => "Referral Commision",
                                'type' => 'credited'
                            ];
                            $referral_history = WalletHistory::create($wallet_history);
                        }
                    }
                }
    
                if(!empty($get_ref_user_name) && !empty($get_ref_user_firt)){
    
                    $get_second_level_user_name = User::where('id',$get_ref_user_name['refferal_from'])->first();
                    
                    if(!empty($get_second_level_user_name)){
                        $get_second_ref_user_list = User::where('refferal_from',$get_second_level_user_name['id'])->get()->toArray();
                        $get_ref_user_second = User::where('refferal_from',$get_second_level_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
    
                    }else{
                        $get_second_ref_user_list = [];
                        $get_ref_user_second = [];
    
                    }
                    
                    
                    if(!empty($get_ref_user_second)){
                        // foreach($get_ref_user_second as $rs_data){
                            
                            $second_user = User::where('id',$get_ref_user_second[0]['refferal_from'])->first();
                            $amount_second = ($get_plan_data['coin']*10)/100;
                    
                            //update wallet amount
                            $walletAmount_second = $second_user['wallet_balance'] + $amount_second;
                            $update_wallet_balance = User::where('id',$second_user['id'])->update(['wallet_balance'=>$walletAmount_second, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
    
                            //add wallet history
                            $wallet_history_second = [
                                'user_id' => $get_ref_user_second[0]['refferal_from'],
                                'source_id' => $user->id,
                                'plan_id' => $input['plan_id'],
                                'coin' => $amount_second,
                                'title' => 'referral_commision',
                                'display_text' => "Referral Commision",
                                'type' => 'credited'
                            ];
                            $referral_history = WalletHistory::create($wallet_history_second);
                        // }
                    }
    
                    if(!empty($get_second_level_user_name) && !empty($get_ref_user_second)){
                        $get_third_level_user_name = User::where('id',$get_second_level_user_name['refferal_from'])->first();
                        $get_third_ref_user_list = User::where('refferal_from',$get_third_level_user_name['id'])->get()->toArray();
                    
                        $get_ref_user_third = User::where('refferal_from',$get_third_level_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
                        
                        if(!empty($get_ref_user_third)){
                            // foreach($get_ref_user_third as $r_data){
    
                                $third_user = User::where('id',$get_ref_user_third[0]['refferal_from'])->first();
                                $amount = ($get_plan_data['coin']*5)/100;
                                
                                //update wallet amount
                                $walletAmount = $third_user['wallet_balance'] + $amount;
                                $update_wallet_balance = User::where('id',$third_user['id'])->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
    
                                //add wallet history
                                $wallet_history = [
                                    'user_id' => $third_user['id'],
                                    'source_id' => $user->id,
                                    'plan_id' => $input['plan_id'],
                                    'coin' => $amount,
                                    'title' => 'referral_commision',
                                    'display_text' => "Referral Commision",
                                    'type' => 'credited'
                                ];
                                $referral_history = WalletHistory::create($wallet_history);
                                
                            // }
    
                        }
                    }
                    
                }
    
                //create purchase history
                $ed = '+'.$get_plan_data['days'].' days';
                $expiry_date = date('Y-m-d', strtotime($ed));
                $data = [
                    'user_id'=>$user->id,
                    'plan_id'=>$input['plan_id'],
                    'title'=>"plan_purchase",
                    'display_text'=>"Plan Purchase",
                    'activated_date'=>date('Y-m-d'),
                    'expiry_date'=>$expiry_date,
                    'status'=>'active'
                ];
                $plan_history = CardHistory::create($data);
    
                //update user wallet
                $amount_updated = $user->wallet_balance - $get_plan_data['coin'];
                $user_bUdate = User::where('id',$user->id)->update(['wallet_balance' => $amount_updated, 'wallet_update_date'=>date('Y-m-d')]);
                return $this->sendResponse($plan_history, 'Plan purchase successfully!');
    
            }else{
                // return $this->sendResponse("", 'Please Add Fund To Your Wallet!');
              return $this->sendError('Error', ['error'=>"Please Add Fund To Your Wallet!"]);
            }
        }else{
            // return $this->sendResponse("", 'Plan already purchase!');
            return $this->sendError('Error', ['error'=>"Plan already purchase!"]);
        }
         
    }

    public function createPayment()
    {        
        // $txn_id = "102563";
        $curl = curl_init();
        // $fields = array("txn_id" => $txn_id, "version" => "1.0");
        // $fields = [];

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://plisio.net/api/v1/operations?api_key=aTi9GbCnC2NBeJojKdH_pUQaVE2xxG6i10SctW8_grKI1SoH4hERE9oYcixtt9f0",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "GET",
            // CURLOPT_POSTFIELDS => $fields,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json",
                // "HMAC: sasas",
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function invoice_create(Request $request){
        $plisioGateway = new Payment(config('plisio.api_key'));
        // $shopInfo = $plisioGateway->getShopInfo();
       // print_r($shopInfo);die;

        $input = $request->all();

        $validator = Validator::make($request->all(), [
            'amount' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }
     
        $params['order_description'] = "video-reward";
        $params['amount'] = $input['amount'];
        $params['currency'] = "USD";
        $params['invoiceid'] = rand(100000,999999);
        $params['clientdetails']['email'] = "monikagemsphp@gmail.com";

        $data = array(
            'order_name' => 'Order #' . $params['invoiceid'], //Merchant internal order name.
            'order_number' => $params['invoiceid'],           //Merchant internal order number. Must be a unique number in your store for each new store`s order.
            'description' => $params['order_description'],    //Optional order description.
            'source_amount' => number_format($params['amount'], 8, '.', ''),  //Invoice total float value in fiat currency.
            'source_currency' => $params['currency'],         //Fiat currency code. For example: USD, BRL, CAD etc.
            'cancel_url' => 'https://examplestore.com/failedOrder.php?id=' . $params['invoiceid'],  //User will be redirected to this link in a case of invoice payment failure.
            'callback_url' => 'https://examplestore.com/callback.php',       //The link to which you will receive a notification about a change in the status of the order.
            'success_url' => 'https://examplestore.com/successOrder.php?id=' . $params['invoiceid'],  //User will be redirected to this link in a case of invoice payment success.
            'email' => $params['clientdetails']['email'],     //User's email. If not specified user will be asked to enter his email on the invoice page.
            'plugin' => 'laravelSdk',                         //Payment gateway origin. This value will help Plisio to analyse any problem occurred with SDK functionality.
            'version' => '1.0.0'                              //Consider updating this setting every time you update the functionality related to this sdk.
        );
            
        //Create invoice and put response to the $response variable.
        $response = $plisioGateway->createTransaction($data);
     
        $user = Auth::user();
        $data = [
            'user_id' => $user->id,
            'transation_id' => $response['data']['txn_id'],
            'coin'=>$input['amount'],
            'title'=>'deposit', 
            'display_text'=>"Fund Deposit",
            'type'=>"credited",
            'date'=>date('Y-m-d'),
            'status'=>'pending'
        ];
        $history = WalletHistory::create($data);

        return $this->sendResponse($response, 'Successfully!');
    }

    public function add_wallet_amount(Request $request){
        $input = $request->all();

        $validator = Validator::make($request->all(), [
            'amount' => 'required',
            'transation_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }
        $user = Auth::user();

        //temporary comment
        // $data = [
        //     'user_id' => $user->id,
        //     'coin'=>$input['amount'],
        //     'title'=>'deposit', 
        //     'display_text'=>" ",
        //     'type'=>"credited",
        //     'date'=>date('Y-m-d'),
        // ];
       
        // $history = WalletHistory::create($data);

        // added
        $update_payment_status = WalletHistory::where('transation_id',$input['transation_id'])->update(['status'=>'success']);

        $wallet__amount = $user['wallet_balance'] + $input['amount'];
        $update_user_wallet = User::where('id',$user->id)->update(['wallet_balance'=>$wallet__amount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
        return $this->sendResponse([], 'Fund Deposit successfully.');

    }

    public function withdrawal_request(Request $request){
        $input = $request->all();
        $validator = Validator::make($request->all(), [
            'amount' => 'required',
            'address' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        $user = Auth::user();

        if($input['amount'] <= $user['wallet_balance']){
            $data = [
                'user_id' => $user->id,
                'coin'=>$input['amount'],
                'withdrawal_address'=>$input['address'],
                'title'=>'withdrawl', 
                'display_text'=>"Withdrawl",
                'type'=>"debited",
                'date'=>date('Y-m-d'),
                'status'=>'pending'
            ];
    
            $history = WalletHistory::create($data);
    
            $wallet__amount = $user['wallet_balance'] - $input['amount'];
            $update_user_wallet = User::where('id',$user->id)->update(['wallet_balance'=>$wallet__amount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
            return $this->sendResponse($history, 'Successfully.');
        }else{
            return $this->sendError('Error', ['error'=>"You can not withdraw amount more than wallet balance!"]);
        }
        
    }
}

