<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Controllers\API\BaseController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\HomeBanner;
use App\Models\Setting;
use App\Models\Pool;
use App\Models\WalletHistory;
use DB;
use App\Models\User;


class HomebannerController extends BaseController
{
    public function homebannerList(Request $request) {
        $data = HomeBanner::where('status','=','active')->orderBy('id','desc')->get()->toArray();
        return $this->sendResponse($data, 'Ad list get successfully!');
    }

    public function getSettingData(Request $request){
     
        $app_version = Setting::where('config_key','=','app_version')->pluck('config_value')->first();
        $app_url = Setting::where('config_key','=','app_url')->pluck('config_value')->first();
       
        if(isset($app_version) || isset($app_version)){
            $detail[] = array(
                    'app_version' => $app_version,
                    'app_url' => $app_url,
            );
        }else{
            $detail[] = array(
                'app_version' => "",
                'app_url' => "",
            );
        }
        
        return $this->sendResponse($detail, 'Details get successfully!');
    }

    public function pool_list(Request $request) {
        $data = Pool::where('status','=','active')->orderBy('id','desc')->get()->toArray();

        foreach($data as $key=>$pool_data){
            $total = WalletHistory::where('pools_id',$pool_data['id'])->where('title','=','pool_invest')->sum('coin');
            $data[$key]['total_pool_invest'] = $total;

            if($pool_data['pool_invest_max'] == $total){
                $status = false;
            }else{
                $status = true;
            }

            $data[$key]['pool_disable_status'] = $status;

        }
        return $this->sendResponse($data, 'List get successfully!');
    }

    public function invest_pool(Request $request){
        $input = $request->all();
        $validator = Validator::make($request->all(), [
            'pools_id' => 'required',
            'amount' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'error' => $validator->errors()], 403);
        }

        $user = Auth::user();

        if($input['amount'] <= $user['wallet_balance']){

            $pool_data = Pool::where('id',$input['pools_id'])->first();
        
            if($pool_data['min_amount'] <= $input['amount'] && $pool_data['max_amount'] >= $input['amount']){
                $data = [
                    'user_id' => $user->id,
                    'pools_id' => $input['pools_id'],
                    'coin'=>$input['amount'],
                    'title'=>'pool_invest', 
                    'display_text'=>"Pool Invest",
                    'type'=>"debited",
                    'date'=>date('Y-m-d'),
                    'status'=>'pending'
                ];
        
                $history = WalletHistory::create($data);
        
                $wallet__amount = $user['wallet_balance'] - $input['amount'];
                $update_user_wallet = User::where('id',$user->id)->update(['wallet_balance'=>$wallet__amount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
    
                return $this->sendResponse($history, 'Successfully');
            }else{
                return $this->sendError('Error', ['error'=>"Pool invest min amount is ".$pool_data['min_amount']." and max amount is ".$pool_data['max_amount']]);
            }
            
        }else{
            return $this->sendError('Error', ['error'=>"You can not invest pool amount more than wallet balance!"]);
        }

    }

    public function pool_history(Request $request){
   
        $user = Auth::user();
        $getWalletHistory = WalletHistory::where('title','=','pool_invest')->where('user_id',$user->id)->orderBy('id','desc')->get()->toArray();
        foreach($getWalletHistory as $key=>$data){
            $pool_name = Pool::where('id',$data['pools_id'])->first();

            $getWalletHistory[$key]['pool_name'] = $pool_name['name'];
            $getWalletHistory[$key]['date'] = date('d/m/Y',strtotime($data['date']));
        }
        return $this->sendResponse($getWalletHistory, 'History get successfully!');
    }
    
    
}

