<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Ad;

class AdsController extends Controller
{
    public function index(Request $request) {
        $adData = Ad::orderBy('id','desc')->get()->toArray();
        return view('admin.ads.list')->with(['adData'=>$adData]);
    }

    public function add(Request $request) {
        if ($request->isMethod('post')) {

            $requestData = $request->all();

            // if($file = $request->hasFile('video')) {
            //     $file = $request->file('video') ;

            //     $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['video']->extension();
            //     $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
            //     $destinationPath = storage_path().'/app/public/ads/' ;
            //     $file->move($destinationPath,$fileName);
              
            //     $url = asset('storage/ads/'.$fileName); 
            //     $requestData['video'] = "$url";            
            // }else{
            //     $requestData['video'] = ""; 
            // }

            $data = [
                'title'=>$requestData['title'],
                'date'=>$requestData['date'],
                'coin'=> $requestData['coin'],
                'video'=>$requestData['video'],
                'status'=>$requestData['status']
            ];
           
            $result = Ad::createAd($data);
            if($result){
               return redirect()->route('admin.ads.list')->with('success', 'AD added successfully!');
            }else{
                return redirect()->route('admin.ads.add')->with('error', 'Something went wrong, please try again');
            }
        }
        return view('admin.ads.add');
    }

    public function update(Request $request,$id=NULL){
       
        if ($request->isMethod('get')) {
            $ad = Ad::where('id',$id)->first();
            return view('admin.ads.update')->with(['ad'=>$ad]);
        }

        if($request->isMethod('post')){
            $requestData = $request->all();

            // if($file = $request->hasFile('video')) {
            //     $file = $request->file('video') ;

            //     $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['video']->extension();
            //     $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
            //     $destinationPath = storage_path().'/app/public/ads/' ;
            //     $file->move($destinationPath,$fileName);
              
            //     $url = asset('storage/ads/'.$fileName); 
            //     $requestData['video'] = "$url";            
            // }else{
            //     $requestData['video'] = Ad::find($requestData['id'])->video;
            // }
         
            if(Ad::updateAds($requestData)){
                return redirect()->route('admin.ads.list')->with('success', 'Ad updated successfully');
            }else{
                return redirect()->route('admin.ads.update',['id'=>$requestData['id']])->with('error', 'Something went wrong, please try again');
            }
                
        }
    }

    public function delete(Request $request,$ad_id=0){
        if($request->isMethod('get')){

            $delete = Ad::deleteAd($ad_id);        
            if($delete){
                return redirect()->route('admin.ads.list')->with('success','Ad deleted successfully');
            }else{
                return redirect()->route('admin.ads.list')->with('error','Please try again');
            }
        }
    }

}
