<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Course;

class CourseController extends Controller
{
    public function index(Request $request) {
        $courseData = Course::orderBy('id','desc')->get()->toArray();
        return view('admin.course.list')->with(['courseData'=>$courseData]);
    }

    public function add(Request $request) {
        if ($request->isMethod('post')) {

            $requestData = $request->all();

            if($file = $request->hasFile('pdf')) {
                $file = $request->file('pdf') ;

                $file_Name = str_replace(' ','_',$requestData['name']).'_'.time().'.'.$requestData['pdf']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/course/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/course/'.$fileName); 
                $requestData['pdf'] = "$url";            
            }else{
                $requestData['pdf'] = ""; 
            }

            $data = [
                'name'=>$requestData['name'],
                'fees'=>$requestData['fees'],
                'duration'=> $requestData['duration'],
                'pdf'=> $requestData['pdf'],
                'status'=>$requestData['status']
            ];
           
            $result = Course::createCourse($data);
            if($result){
               return redirect()->route('admin.course.list')->with('success', 'Course added successfully!');
            }else{
                return redirect()->route('admin.course.add')->with('error', 'Something went wrong, please try again');
            }
        }
        return view('admin.course.add');
    }

    public function update(Request $request,$id=NULL){
       
        if ($request->isMethod('get')) {
            $course = Course::where('id',$id)->first();
            return view('admin.course.update')->with(['course'=>$course]);
        }

        if($request->isMethod('post')){
            $requestData = $request->all();

            if($file = $request->hasFile('pdf')) {
                $file = $request->file('pdf') ;

                $file_Name = str_replace(' ','_',$requestData['name']).'_'.time().'.'.$requestData['pdf']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/course/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/course/'.$fileName); 
                $requestData['pdf'] = "$url";            
            }else{
                $requestData['pdf'] = Course::find($requestData['id'])->pdf;
            }
         
         
            if(Course::updateCourse($requestData)){
                return redirect()->route('admin.course.list')->with('success', 'Course updated successfully');
            }else{
                return redirect()->route('admin.course.update',['id'=>$requestData['id']])->with('error', 'Something went wrong, please try again');
            }
                
        }
    }

    public function delete(Request $request,$course_id=0){
        if($request->isMethod('get')){

            $delete = Course::deleteCourse($course_id);        
            if($delete){
                return redirect()->route('admin.course.list')->with('success','Course deleted successfully');
            }else{
                return redirect()->route('admin.course.list')->with('error','Please try again');
            }
        }
    }
}
