<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HomeBanner;

class HomeBannerController extends Controller
{
    public function index(Request $request) {
        $bannerData = HomeBanner::orderBy('id','desc')->get()->toArray();
        return view('admin.homebanner.list')->with(['bannerData'=>$bannerData]);
    }

    public function add(Request $request) {
        if ($request->isMethod('post')) {

            $requestData = $request->all();

            if($file = $request->hasFile('image')) {
                $file = $request->file('image') ;

                $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['image']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/homebanner/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/homebanner/'.$fileName); 
                $requestData['image'] = "$url";            
            }else{
                $requestData['image'] = ""; 
            }

            $data = [
                'title'=>$requestData['title'],
                'description'=>$requestData['description'],
                'image'=>$requestData['image'],
                'status'=>$requestData['status']
            ];
           
            $result = HomeBanner::createHomeBanner($data);
            if($result){
               return redirect()->route('admin.home-banner.list')->with('success', 'Home banner added successfully!');
            }else{
                return redirect()->route('admin.home-banner.list')->with('error', 'Something went wrong, please try again');
            }
        }
        return view('admin.homebanner.add');
    }

    public function update(Request $request,$id=NULL){
       
        if ($request->isMethod('get')) {
            $banner = HomeBanner::where('id',$id)->first();
            return view('admin.homebanner.update')->with(['banner'=>$banner]);
        }

        if($request->isMethod('post')){
            $requestData = $request->all();

            if($file = $request->hasFile('image')) {
                $file = $request->file('image') ;

                $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['image']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/homebanner/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/homebanner/'.$fileName); 
                $requestData['image'] = "$url";            
            }else{
                $requestData['image'] = HomeBanner::find($requestData['id'])->image;
            }
         
            if(HomeBanner::updateHomebanner($requestData)){
                return redirect()->route('admin.home-banner.list')->with('success', 'Home banner updated successfully');
            }else{
                return redirect()->route('admin.home-banner.update',['id'=>$requestData['id']])->with('error', 'Something went wrong, please try again');
            }
                
        }
    }

    public function delete(Request $request,$banner_id=0){
        if($request->isMethod('get')){

            $delete = HomeBanner::deleteHomebanner($banner_id);        
            if($delete){
                return redirect()->route('admin.home-banner.list')->with('success','Home banner deleted successfully');
            }else{
                return redirect()->route('admin.home-banner.list')->with('error','Please try again');
            }
        }
        
    }

}
