<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Lead;
use App\Models\Course;

class LeadController extends Controller
{
    public function index(Request $request) {
        $leadData = Lead::orderBy('id','desc')->get()->toArray();
        return view('admin.lead.list')->with(['leadData'=>$leadData]);
    }

    public function add(Request $request) {
        if ($request->isMethod('post')) {

            $requestData = $request->all();

            $data = [
                'name'=>$requestData['name'],
                'email'=>$requestData['email'],
                'mobile'=> $requestData['mobile'],
                // 'mobile'=> $requestData['mobile'],
                // 'course_id'=> $requestData['course_id'],
                'college_name'=> $requestData['college_name'],
                'status'=>$requestData['status']
            ];
           
            $result = Lead::createLead($data);
            if($result){
               return redirect()->route('admin.lead.list')->with('success', 'Lead added successfully!');
            }else{
                return redirect()->route('admin.lead.add')->with('error', 'Something went wrong, please try again');
            }
        }
        return view('admin.lead.add');
    }

    public function update(Request $request,$id=NULL){
       
        if ($request->isMethod('get')) {
            $lead = Lead::where('id',$id)->first();
            return view('admin.lead.update')->with(['lead'=>$lead]);
        }

        if($request->isMethod('post')){
            $requestData = $request->all();
         
            if(Lead::updateLead($requestData)){
                return redirect()->route('admin.lead.list')->with('success', 'Lead updated successfully');
            }else{
                return redirect()->route('admin.lead.update',['id'=>$requestData['id']])->with('error', 'Something went wrong, please try again');
            }
                
        }
    }
}
