<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Carbon\Carbon;
use App\Models\User;
use Hash;
use Auth;
use DB;

class LoginController extends Controller
{
    public function validateLogin(Request $request) {
        $requestData = $request->all();
        // $request->validate([
        //     'email' => 'required|string',
        //     'password' => 'required|string',
        // ]);
      
        $username = $requestData['username']; 
        $password = $request['password'];
        $remember = $request->has('remember') ? true : false;
       
        if(filter_var($username, FILTER_VALIDATE_EMAIL)) {
            //user sent their email 
            Auth::attempt(['email' => $username, 'password' => $password,'user_type' => '1'],$remember);

        }else if(is_numeric($username)){
            //they sent their mobile instead 
            Auth::attempt(['mobile' => $username, 'password' => $password,'user_type' => '1'],$remember);
            
        }else{
            //they sent their username instead 
            Auth::attempt(['name' => $username, 'password' => $password,'user_type' => '1'],$remember);
        }
        
        //was any of those correct ?
        if ( Auth::check() ) {
            //send them where they are going 
            return redirect()->route('admin.home')->with('status', 'You are logged in!');
        }
        /*
         * This code for check only using username
         * $credentials = $request->only('username', 'password');

        if (Auth::attempt($credentials)) {
            return redirect()->route('admin.home')->with('status', 'You are logged in!');
        }*/

        return redirect()->route('admin.login')->with('error', 'Opps! You have entered invalid credentials');
    }

    public function logout() {
        Auth::logout();
        return redirect()->route('admin.login')->with('logout', 'You are logged out!');
    }
}
