<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Plan;

class PlanController extends Controller
{
    public function index(Request $request) {
        $planData = Plan::orderBy('id','desc')->get()->toArray();
        return view('admin.plan.list')->with(['planData'=>$planData]);
    }

    public function add(Request $request) {
        if ($request->isMethod('post')) {

            $requestData = $request->all();

            if($file = $request->hasFile('image')) {
                $file = $request->file('image') ;

                $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['image']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/plan/image/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/plan/image/'.$fileName); 
                $requestData['image'] = "$url";            
            }else{
                $requestData['image'] = Plan::find($requestData['id'])->image;
            }

            //bg plan image
            if($file = $request->hasFile('bg_plan_image')) {
                $file = $request->file('bg_plan_image') ;

                $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['bg_plan_image']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/plan/bg_plan_image/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/plan/bg_plan_image/'.$fileName); 
                $requestData['bg_plan_image'] = "$url";            
            }else{
                $requestData['bg_plan_image'] = "";
            }

            //bg card image
            if($file = $request->hasFile('bg_card_image')) {
                $file = $request->file('bg_card_image') ;

                $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['bg_card_image']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/plan/bg_card_image/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/plan/bg_card_image/'.$fileName); 
                $requestData['bg_card_image'] = "$url";            
            }else{
                $requestData['bg_card_image'] = "";
            }

            //bg plan normal
            if($file = $request->hasFile('bg_plan_normal')) {
                $file = $request->file('bg_plan_normal') ;

                $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['bg_plan_normal']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/plan/bg_plan_normal/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/plan/bg_plan_normal/'.$fileName); 
                $requestData['bg_plan_normal'] = "$url";            
            }else{
                $requestData['bg_plan_normal'] = "";
            }

            $data = [
                'title'=>$requestData['title'],
                'coin'=>$requestData['coin'],
                'days'=> $requestData['days'],
                'daily_revenue'=> $requestData['daily_revenue'],
                'status'=>$requestData['status'],
                'max_earn'=>$requestData['max_earn'],
                'roi'=>$requestData['roi'],
                'image'=>$requestData['image'],
                'bg_plan_image'=>$requestData['bg_plan_image'],
                'bg_card_image'=>$requestData['bg_card_image'],
                'bg_plan_normal'=>$requestData['bg_plan_normal'],
            ];
           
            $result = Plan::createPlan($data);
            if($result){
               return redirect()->route('admin.plan.list')->with('success', 'Plan added successfully!');
            }else{
                return redirect()->route('admin.plan.add')->with('error', 'Something went wrong, please try again');
            }
        }
        return view('admin.plan.add');
    }

    public function update(Request $request,$id=NULL){
       
        if ($request->isMethod('get')) {
            $plan = Plan::where('id',$id)->first();
            return view('admin.plan.update')->with(['plan'=>$plan]);
        }

        if($request->isMethod('post')){
            $requestData = $request->all();

            if($file = $request->hasFile('image')) {
                $file = $request->file('image') ;

                $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['image']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/plan/image/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/plan/image/'.$fileName); 
                $requestData['image'] = "$url";            
            }else{
                $requestData['image'] = Plan::find($requestData['id'])->image;
            }

            //bg plan image
            if($file = $request->hasFile('bg_plan_image')) {
                $file = $request->file('bg_plan_image') ;

                $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['bg_plan_image']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/plan/bg_plan_image/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/plan/bg_plan_image/'.$fileName); 
                $requestData['bg_plan_image'] = "$url";            
            }else{
                $requestData['bg_plan_image'] = Plan::find($requestData['id'])->bg_plan_image;
            }

            //bg card image
            if($file = $request->hasFile('bg_card_image')) {
                $file = $request->file('bg_card_image') ;

                $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['bg_card_image']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/plan/bg_card_image/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/plan/bg_card_image/'.$fileName); 
                $requestData['bg_card_image'] = "$url";            
            }else{
                $requestData['bg_card_image'] = Plan::find($requestData['id'])->bg_card_image;
            }

            //bg plan normal
            if($file = $request->hasFile('bg_plan_normal')) {
                $file = $request->file('bg_plan_normal') ;

                $file_Name = str_replace(' ','_',$requestData['title']).'_'.time().'.'.$requestData['bg_plan_normal']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/plan/bg_plan_normal/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/plan/bg_plan_normal/'.$fileName); 
                $requestData['bg_plan_normal'] = "$url";            
            }else{
                $requestData['bg_plan_normal'] = Plan::find($requestData['id'])->bg_plan_normal;
            }
         
            if(Plan::updatePlan($requestData)){
                return redirect()->route('admin.plan.list')->with('success', 'Plan updated successfully');
            }else{
                return redirect()->route('admin.plan.update',['id'=>$requestData['id']])->with('error', 'Something went wrong, please try again');
            }
                
        }
    }

    public function delete(Request $request,$plan_id=0){
        if($request->isMethod('get')){

            $delete = Plan::deletePlan($plan_id);        
            if($delete){
                return redirect()->route('admin.plan.list')->with('success','Plan deleted successfully');
            }else{
                return redirect()->route('admin.plan.list')->with('error','Please try again');
            }
        }
        
    }
}
