<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pool;

class PoolController extends Controller
{
    public function index(Request $request) {
        $poolData = Pool::orderBy('id','desc')->get()->toArray();
        return view('admin.pool.list')->with(['poolData'=>$poolData]);
    }

    public function add(Request $request) {
        if ($request->isMethod('post')) {

            $requestData = $request->all();
            $data = [
                'name'=>$requestData['name'],
                'days'=>$requestData['days'],
                'min_amount'=> $requestData['min_amount'],
                'max_amount'=> $requestData['max_amount'],
                'percent'=>$requestData['percent'],
                'time'=>$requestData['time'],
                'status'=>$requestData['status'],
            ];
           
            $result = Pool::createPool($data);
            if($result){
               return redirect()->route('admin.pool.list')->with('success', 'Pool added successfully!');
            }else{
                return redirect()->route('admin.pool.add')->with('error', 'Something went wrong, please try again');
            }
        }
        return view('admin.pool.add');
    }

    public function update(Request $request,$id=NULL){
       
        if ($request->isMethod('get')) {
            $pool = Pool::where('id',$id)->first();
            return view('admin.pool.update')->with(['pool'=>$pool]);
        }

        if($request->isMethod('post')){
            $requestData = $request->all();

            if(Pool::updatePool($requestData)){
                return redirect()->route('admin.pool.list')->with('success', 'Pool updated successfully');
            }else{
                return redirect()->route('admin.pool.update',['id'=>$requestData['id']])->with('error', 'Something went wrong, please try again');
            }
                
        }
    }

    public function delete(Request $request,$plan_id=0){
        if($request->isMethod('get')){

            $delete = Pool::deletePool($plan_id);        
            if($delete){
                return redirect()->route('admin.pool.list')->with('success','Pool deleted successfully');
            }else{
                return redirect()->route('admin.pool.list')->with('error','Please try again');
            }
        }
        
    }
}
