<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use DataTables;
use Auth;
use App\models\User;

class SettingController extends Controller
{
    public function index(Request $request) {
        $settingData = Setting::orderBy('id','desc')->get()->toArray();
        return view('admin.setting.index')->with(['settingData'=>$settingData]);
    }

    public function saveBasic(Request $request) {
        $data = $request->all();
       
        foreach ($data AS $key => $value) { 
            // Setting::updateOrCreate(['config_key' => $re_status],['config_key' => $re_status,'config_value' => $value]);

            Setting::where('config_key','=',$key)->update(['config_value' => $value]);     
            // if($key != '_token'){
            //     if($key == 'Registration_Status'){
            //         $re_status = str_replace('_', ' ', $key);
            //     }else{
            //         $re_status = $key;
            //     }
            //     // $setting = Setting::where('key','')
            //     // Setting::where('key','=',$key)->update(['value' => $value]);                 
            // }
          
        }
        return redirect()->route('admin.setting')->with('success',' Details updated successfully');
    }

    public function updateProfile(Request $request){
        $user_data = Auth::user();
        return view('admin.update-profile')->with(['user_data'=>$user_data]);
    }

    public function editProfile(Request $request){
        $input = $request->all();
        $user_id = Auth::user();
     
         //photo document
         if($file = $request->hasFile('photo')) {
            $file = $request->file('photo') ;
            $file_Name = str_replace(' ','_',$input['name']).'_'.time().'.'.$input['photo']->extension();
            $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
            $destinationPath = storage_path().'/app/public/admin/profile/' ;
            $file->move($destinationPath,$fileName);
            $url = asset('storage/app/public/admin/profile/'.$fileName);
            $imageUrl = "$url"; 
            
        }else{
            $imageUrl = $user_id['photo'];
        }
        
        $user = User::find($user_id['id']);
        $user->id = $user_id['id'];
        $user->name = $input['name'];
        $user->photo = $imageUrl;
        $user->save();

        if($user){
            return redirect()->route('admin.profile.update')->with('success', 'Profile updated successfully');
        }else{
            return redirect()->route('admin.profile.update')->with('error', 'Something went wrong, please try again');
        }

    }
}
