<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\WalletHistory;
use App\Models\Course;
use App\Models\Setting;
use PDF;

class UserController extends Controller
{
    public function index(Request $request) {
        $userData = User::where('user_type','!=','1')->orderBy('id','desc')->get()->toArray();
        return view('admin.user.list')->with(['userData'=>$userData]);
    }

    public function add(Request $request) {
        if ($request->isMethod('post')) {

            $requestData = $request->all();
            if($file = $request->hasFile('image')) {
                $file = $request->file('image') ;

                $file_Name = str_replace(' ','_',$requestData['name']).'_'.time().'.'.$requestData['image']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/user_profile/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/user_profile/'.$fileName); 
                $requestData['image'] = "$url";            
            }else{
                $requestData['image'] = ""; 
            }

            if($file = $request->hasFile('certificate')) {
                $file = $request->file('certificate') ;

                $file_Name = str_replace(' ','_',$requestData['name']).'_'.time().'.'.$requestData['certificate']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/user_certificate/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/user_certificate/'.$fileName); 
                $requestData['certificate'] = "$url";            
            }else{
                $requestData['certificate'] = ""; 
            }

            $referral_bonus = Setting::where('config_key', 'referral_bonus')->get('config_value');
            $reffered_user = User::where('id',$requestData['refferal_from'])->first();
            $fees = Course::where('id',$requestData['course_id'])->first();

            $unique_id=rand('10000000','99999999');
            $data = [
                'name'=>$requestData['name'],
                'email'=>$requestData['email'],
                'mobile'=> $requestData['mobile'],
                'user_type'=> '2',
                'password'=>$requestData['password'],
                'mobile'=> $requestData['mobile'],
                'college_name'=> $requestData['college_name'],
                'course_id'=> $requestData['course_id'],
                'unique_id'=>$unique_id,
                'image'=>$requestData['image'],
                'refferal_from'=>$requestData['refferal_from'],
                'payment_status'=>$requestData['payment_status'],
                'certificate'=>$requestData['certificate'],
                'status'=>$requestData['status']
            ];
            $result = User::createUser($data);

            if(!empty($reffered_user)){
                $referral_bonus_percent = ($fees['fees']*$referral_bonus[0]['config_value'])/100;
                $wallet_balance = $reffered_user['wallet_balance'] + $referral_bonus_percent;
                $update_user = User::where('id',$reffered_user['id'])->update(['wallet_balance'=>$wallet_balance]);

                //insert into wallet-history 
                $wallet_history_data = ['user_id'=>$reffered_user['id'],
                                   'source_id'=>$result['id'],
                                   'amount'=>$referral_bonus_percent,
                                   'type'=>'credited',
                                   'title'=>'referral_bonus'
                                  ];

                $wallet_history = WalletHistory::create($wallet_history_data);
            }

            if($result){
               return redirect()->route('admin.user.list')->with('success', 'User added successfully!');
            }else{
                return redirect()->route('admin.user.add')->with('error', 'Something went wrong, please try again');
            }
        }
        return view('admin.user.add');
    }

    public function update(Request $request,$id=NULL){
       
        if ($request->isMethod('get')) {
            $user = User::where('id',$id)->first();
            return view('admin.user.update')->with(['user'=>$user]);
        }

        if($request->isMethod('post')){
            $requestData = $request->all();

            if($file = $request->hasFile('image')) {
                $file = $request->file('image') ;

                $file_Name = str_replace(' ','_',$requestData['name']).'_'.time().'.'.$requestData['image']->extension();
                $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
                $destinationPath = storage_path().'/app/public/user/photo/' ;
                $file->move($destinationPath,$fileName);
              
                $url = asset('storage/user/photo/'.$fileName); 
                $requestData['image'] = "$url";            
            }else{
                $requestData['image'] = User::find($requestData['id'])->image;
            }
         
            if(User::updateUser($requestData)){
                return redirect()->route('admin.user.list')->with('success', 'User updated successfully');
            }else{
                return redirect()->route('admin.user.update',['id'=>$requestData['id']])->with('error', 'Something went wrong, please try again');
            }
                
        }
    }

    public function delete(Request $request,$user_id=0){
        if($request->isMethod('get')){

            $delete = User::deleteUser($user_id);        
            if($delete){
                return redirect()->route('admin.user.list')->with('success','User deleted successfully');
            }else{
                return redirect()->route('admin.user.list')->with('error','Please try again');
            }
        }
        
    }

    public function view(Request $request,$user_id=NULL) {
        $referredUserData = User::where('refferal_from',$user_id)->orderBy('id','desc')->get()->toArray();
        return view('admin.user.view')->with(['referredUserData'=>$referredUserData]);
    }

    public function viewLevel2(Request $request,$user_id=NULL) {
        $referredUserData = User::where('refferal_from',$user_id)->orderBy('id','desc')->get()->toArray();
        return view('admin.user.view_level2')->with(['referredUserData'=>$referredUserData]);
    }

    public function viewLevel3(Request $request,$user_id=NULL) {
        $referredUserData = User::where('refferal_from',$user_id)->orderBy('id','desc')->get()->toArray();
        return view('admin.user.view_level3')->with(['referredUserData'=>$referredUserData]);
    }

    public function walletHistoryUser(Request $request,$user_id=NULL) {
        $deposit_history = WalletHistory::where('user_id',$user_id)->where('title','=','deposit')->get()->toArray();
        $withdrawal_history = WalletHistory::where('user_id',$user_id)->where('title','=','withdrawl')->get()->toArray();
        $wallet_history = WalletHistory::where('user_id',$user_id)->where('title','=','referral_commision')->orWhere('title','=','watch_add')->get()->toArray();
        
        return view('admin.user.wallet_history')->with(['deposit_history'=>$deposit_history, 'withdrawal_history'=>$withdrawal_history, 'wallet_history'=>$wallet_history]);
    }
   
    public function generate_certificate_list(Request $request){
        $userData = User::where('user_type','!=','1')->orderBy('id','desc')->get()->toArray();
        return view('admin.generate-certificate.list')->with(['userData'=>$userData]);
    }

    // public function generatePdf(Request $request,$id=NULL)
    // {
    //     $data = ['title' => 'Welcome to Laravel PDF generation'];
        
    //     // Load a view and pass the data
    //     $pdf = PDF::loadView('admin.generate-certificate.generate-pdf', $data);
    
    //     $user = User::where('id',$id)->first();
    //     $update_user = User::where('id',$id)->update(['certificate'=>$pdf]);
        
    //     // Stream the generated PDF to the browser
    //     return $pdf->stream('document.pdf');
    // }

    public function generatePdf(Request $request, $id = NULL)
    {
       // Data to pass to the view
        // $data = ['title' => 'Welcome to Laravel PDF generation'];
        $data['data'] = User::where('id', $id)->first();
        $data['course_name'] = Course::where('id', $data['data']['id'])->first();
        
        // Load the view and generate the PDF
        $pdf = PDF::loadView('admin.generate-certificate.generate-pdf', $data)->setPaper('a3', 'landscape');
        
        // Define the file name
        $fileName = 'certificate_' . $id . '_' . time() . '.pdf';
        $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $fileName); // Sanitize file name
        
        // Define the path where you want to save the PDF
        $destinationPath = storage_path('app/public/certificates/');
        
        // Make sure the directory exists
        if (!file_exists($destinationPath)) {
            mkdir($destinationPath, 0777, true);
        }
        
        // Save the PDF to the specified path
        $pdf->save($destinationPath . $fileName);
        
        // Get the URL of the saved PDF
        $url = asset('storage/certificates/' . $fileName);
        
        // Update the user's record with the URL to the saved PDF
        $update_user = User::where('id', $id)->update(['certificate' => $url]);

        // return redirect()->route('admin.generate-certificate.list')->with('success','PDF generated and saved successfully!');
        
        // Return a response if needed
        // return response()->json(['message' => 'PDF generated and saved successfully', 'url' => $url]);

        //  Stream the generated PDF to the browser
         return $pdf->stream('document.pdf');
    }

}
