<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WalletHistory;

class WalletHistoryController extends Controller
{
    public function index(Request $request) {
        $walletHistoryData = WalletHistory::get()->toArray();
        return view('admin.wallet-history.list')->with(['walletHistoryData'=>$walletHistoryData]);
    }

    public function deposit_history(Request $request){
        $depositHistoryData = WalletHistory::where('title','=','deposit')->get()->toArray();
        return view('admin.deposit-history.list')->with(['depositHistoryData'=>$depositHistoryData]);
    }

    public function withdrawal_history(Request $request){
        $withdrawlHistoryData = WalletHistory::where('title','=','withdrawl')->get()->toArray();
        return view('admin.withdrawl-history.list')->with(['withdrawlHistoryData'=>$withdrawlHistoryData]);
    }

    public function changeWithdrawalStatusByAdmin(Request $request){
        $post = WalletHistory::find($request->history_id);
        if($request->status == '1'){
            $post_s= 'success';
        }else{
            $post_s = 'pending';
        }
       
        $post->status = $post_s;
        $post->save();

        if($post){
            return response()->json(['success'=>'Status change successfully!']);
        }
    }

    public function change_withdrawal_request_status(Request $request)
    {  
   
        if($request->isMethod('post')){
            $requestData = $request->all();
 
            $status = false;
            foreach($requestData['request_id'] AS $id){
                WalletHistory::where('id',$id)->update(['status'=>'success']);
                $status = true;
            }
            
            if($status){
                return json_encode(array('status'=>1,'message'=>'Status Change successfully'));
            }else{
                return json_encode(array('status'=>0,'message'=>'Error While Change Status'));
            }
        }
    }
}
