<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\User;
use App\Models\WalletHistory;
use App\Models\Pool;
use Auth;
use App\Traits\FcmNotificationService;

class CronJobController extends Controller
{
    
    use FcmNotificationService;
    public function pool_invest_earning(){
        $pool_invest_history = WalletHistory::where('title','=','pool_invest')->where('status','=','pending')->get()->toArray();
        
        foreach($pool_invest_history as $pool_data){
            $pool_all_data = Pool::where('id',$pool_data['pools_id'])->first();

            // $next_due_date = date('Y-m-d', strtotime("+30 days")); //2023-11-08
            $ed =' +'.$pool_all_data['days'].' days';
            $expiry_date = date('Y-m-d', strtotime($pool_data['date']. $ed)); //2023-11-04
            $today = date('Y-m-d');

            if($expiry_date < $today){
                $update_status = WalletHistory::where('id',$pool_data['id'])->update(['status' =>'success', 'type'=>'credited']);
               
                $amount = $pool_data['coin']*$pool_all_data['percent']/100;
                $total_amount = $amount + $pool_data['coin'];

                $user_wallet = User::where('id',$pool_data['user_id'])->first();

                $notification_data = ['title'=>'Pool Invest Earning!',
                    'message'=>'You got pool invest amount!'  
                ];

                $moredata = ['title'=>'Pool Invest Earning!',
                    'message'=>'You got pool invest amount!'  
                ];
               
                if(!empty($user_wallet)){
                    $final_amount = $user_wallet['wallet_balance'] + $total_amount;
                    $update_wallet = User::where('id',$pool_data['user_id'])->update(['wallet_balance' => $final_amount, 'wallet_update_date' =>date("Y-m-d h:i:s")]);

                    if($user_wallet['fcm_token'] != null){
                        $this->sendFcmNotification($user_wallet['fcm_token'],$notification_data,$moredata);
                    }

                }
                return true;
            }

        }
    }
}
