<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Plan;
use App\Models\CardHistory;
use App\Models\HomeBanner;
use App\Models\WalletHistory;
use App\Models\Pool;
use App\Models\Ad;
use App\Models\Setting;
use App\Models\Course;
use App\Models\Lead;
use Auth;
use DateTime;
use Hash;

class UserDashboardController extends Controller
{
    public function home(Request $request){
        $user = Auth::user();

        // $getPurchaseHistory = CardHistory::where('user_id',$user->id)->where('status','=','active')->orderBy('id','ASC')->get()->toArray();
        // if(!empty($getPurchaseHistory)){
        //     foreach($getPurchaseHistory as $data){
        //         $plan[] = Plan::where('id',$data['plan_id'])->first();
        //     }
        // }else{
        //     $plan = [];
        // }
        // $wallet_data = User::select('wallet_balance','wallet_update_date')->where('id',$user->id)->first();
        // $todayearning = WalletHistory::where('user_id', $user->id)->where('type','=','credited')->where('date', date('Y-m-d'))->sum('coin');
        // $totalreferral = WalletHistory::where('user_id', $user->id)->where('title','=','referral_commission')->sum('coin');

        // $today = date('Y-m-d');
        // $data = Ad::whereDate('date','=',$today)->where('status','=','active')->get()->toArray();
        // $getWalletHistory = WalletHistory::select('ad_id')->where('user_id',$user->id)->whereDate('date','=',$today)->where('title','watch_add')->get()->toArray();

        // if(count($data) == count($getWalletHistory)){
        //     $status = "Your today's task is completed";
        // }else{
        //     $status = "Your today's task is in-complete. Please complete your task!";
        // }
        
        // echo "<pre>"; print_r($user);die;

        $course_name = Course::where('id',$user->course_id)->first();
        $leads = Lead::orderBy('id', 'desc')->limit(10)->get()->toArray();
        return view('web.dashboard')->with(['user'=>$user, 'course_name'=>$course_name, 'leads'=>$leads]);
    }

    public function plan_detail(Request $request,$id=NULL){

        $input['card_history_id'] = $id;
        $user = Auth::user();
        if(isset($input['card_history_id']) && $input['card_history_id'] != ""){
          
            // $getCardHistory = CardHistory::where('user_id',$user->id)->where('plan_id',$input['plan_id'])->where('status','=','active')->orderBy('id','desc')->paginate(2);
            $getCardHistory = CardHistory::where('id',$input['card_history_id'])->where('status','=','active')->orderBy('id','desc')->paginate(10);
            
            foreach($getCardHistory as $key=>$data){
                $plan = Plan::where('id',$data['plan_id'])->first();
                $getCardHistory[$key]['plan_price'] = $plan['coin'];
            }
        }else{
           
            $getPlan = CardHistory::where('user_id',$user->id)->where('status','=','active')->orderBy('id','ASC')->first();
            $getCardHistory = [];
            if(!empty($getPlan)){
                $getCardHistory = CardHistory::where('user_id',$user->id)->where('plan_id',$getPlan['plan_id'])->where('status','=','active')->orderBy('id','desc')->paginate(10);
                foreach($getCardHistory as $key=>$data){
                    $plan = Plan::where('id',$data['plan_id'])->first();
    
                    $getCardHistory[$key]['plan_price'] = $plan['coin'];
                }
            }
        }

        $getPurchaseHistory = CardHistory::where('user_id',$user->id)->where('status','=','active')->orderBy('id','ASC')->get()->toArray();
        if(!empty($getPurchaseHistory)){
            foreach($getPurchaseHistory as $data){
                $active_plan[] = Plan::where('id',$data['plan_id'])->first();
            }
        }else{
            $active_plan = [];
        }
        
        return view('web.plan_detail')->with(['user'=>$user, 'getCardHistory'=>$getCardHistory, 'plan'=>$plan, 'active_plan'=>$active_plan, 'getPurchaseHistory'=>$getPurchaseHistory]);
    }

    public function exchange(Request $request){
        $user = Auth::user();
        $wallet_data = User::select('wallet_balance','wallet_update_date')->where('id',$user->id)->first();
        $wallet_data['wallet_update_date'] = $this->timeago($wallet_data['wallet_update_date']);

        $getWalletHistory = WalletHistory::where('user_id',$user->id)->orderBy('id','desc')->paginate(10);;
        
        foreach($getWalletHistory as $key=>$data){
            $getWalletHistory[$key]['date'] = date('d/m/Y',strtotime( $data['date']));
            
            if($data['plan_id'] != '0'){

                $plan = Plan::where('id',$data['plan_id'])->first();
                $souce_user_name = User::where('id',$data['source_id'])->first();

                $getWalletHistory[$key]['plan_name'] = $plan['title'];
                $getWalletHistory[$key]['souce_user_name'] = ucfirst($souce_user_name['name']);
            }else{
                $getWalletHistory[$key]['plan_name'] ="";
                $getWalletHistory[$key]['souce_user_name'] ="";
            }
        }
      

        return view('web.exchange')->with(['wallet_balance'=>$wallet_data, 'user'=>$user, 'get_wallet_history'=>$getWalletHistory]);
    }

    function timeago($timestamp) {
        $datetime1=new DateTime("now");
        $datetime2=date_create($timestamp);
        $diff=date_diff($datetime1, $datetime2);
        $timemsg='';
        if($diff->y > 0){
            $timemsg = 'Last Updated '. $diff->y .' year'. ($diff->y > 1?"'s":'');
    
        }
        else if($diff->m > 0){
         $timemsg = 'Last Updated '. $diff->m . ' month'. ($diff->m > 1?"'s":'');
        }
        else if($diff->d > 0){
         $timemsg = 'Last Updated '. $diff->d .' day'. ($diff->d > 1?"'s":'');
        }
        else if($diff->h > 0){
         $timemsg = 'Last Updated '. $diff->h .' hour'.($diff->h > 1 ? "'s":'');
        }
        else if($diff->i > 0){
         $timemsg = 'Last Updated '. $diff->i .' minute'. ($diff->i > 1?"'s":'');
        }
        else if($diff->s > 0){
         $timemsg = 'Last Updated '. $diff->s .' second'. ($diff->s > 1?"'s":'');
        }
    
        $timemsg = $timemsg.' ago';
        return $timemsg;
    }

    public function withdraw_request(Request $request){
        $user = Auth::user();
        $input = $request->all();

        if($input['amount'] <= $user['wallet_balance']){
            $data = [
                'user_id' => $user->id,
                'coin'=>$input['amount'],
                // 'withdrawal_address'=>$input['address'],
                'customer_name'=>$input['customer_name'],
                'bank_name'=>$input['bank_name'],
                'ifsc_code'=>$input['ifsc_code'],
                'mobile'=>$input['mobile'],
                'title'=>'withdrawl', 
                'display_text'=>"Withdrawal",
                'type'=>"debited",
                'date'=>date('Y-m-d'),
                'status'=>'pending'
            ];
    
            $history = WalletHistory::create($data);
            $wallet__amount = $user['wallet_balance'] - $input['amount'];
            $update_user_wallet = User::where('id',$user->id)->update(['wallet_balance'=>$wallet__amount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);

            $result = 'true';
            return $result;

        }else{
            $result = 'false';
            return $result;
            // return $this->sendError('Error', ['error'=>"You can not withdraw amount more than wallet balance!"]);
        }
    }

    public function earnings(Request $request){
        $user = Auth::user();
        $wallet_data = User::select('wallet_balance','wallet_update_date')->where('id',$user->id)->first();
        $wallet_data['wallet_update_date'] = $this->timeago($wallet_data['wallet_update_date']);

        $getWalletHistory = WalletHistory::where('title','=','watch_add')->where('type','=','credited')->where('user_id',$user->id)->orderBy('id','desc')->paginate(10);
        foreach($getWalletHistory as $key=>$data){
            $getWalletHistory[$key]['date'] = date('d/m/Y',strtotime($data['date']));
        }
        return view('web.earning')->with(['wallet_balance'=>$wallet_data, 'user'=>$user, 'get_wallet_history'=>$getWalletHistory]);
    }

    public function pool_list(Request $request){
        $user = Auth::user();
        $pool_data = Pool::where('status','=','active')->orderBy('id','desc')->get()->toArray();
        
        return view('web.pool')->with(['pool_data'=>$pool_data, 'user'=>$user]);
    }

    public function setting(Request $request){
        $user = Auth::user();
        return view('web.setting')->with(['user'=>$user]);
    }

    public function deleteAccount(Request $request){
        $data = User::where('id',Auth::user()->id)->delete();
        return redirect()->route('web.login')->with('success', 'User Account Deleted Successfully');
    }

    public function changePassword(Request $request){
        $user = Auth::user();
        return view('web.change-password')->with(['user'=>$user]);
    }

    public function changePasswordSave(Request $request){
        
        $user = Auth::user();
        if ($request->isMethod('POST')) {
            $requestData = $request->all();
      
            $password = $request->input('password');
            $ConfirmPassword = $request->input('confirm_password');
            
            $user = User::where('id',$user->id)->first();
            $convert_pass = Hash::make($password);
       
            if(!Hash::check($password, $user->password)){
        
               return redirect()->route('web.changePassword')->with('error','Old password is wrong!');
        
            }else{
        
                $passwordUpdate = User::changeUserPassword($requestData);
                if($passwordUpdate){
                    return redirect()->route('web.dashboard')->with('success','Password change successfully');
                }else{
                    return redirect()->route('web.changePassword')->with('error','Something went wrong');
                }
        
            }
          
        }
    }

    public function updateProfile(Request $request){
        $user = Auth::user();
        return view('web.update-profile')->with(['user'=>$user]);
    }

    public function updateProfileSave(Request $request){
        $user = Auth::user();
        $requestData = $request->all();

        if($file = $request->hasFile('photo')) {
            $file = $request->file('photo') ;

            $file_Name = str_replace(' ','_',$requestData['name']).'_'.time().'.'.$requestData['photo']->extension();
            $fileName = preg_replace("/[^a-zA-Z0-9.]/", "", $file_Name);
            $destinationPath = storage_path().'/app/public/user/profile' ;
            $file->move($destinationPath,$fileName);
          
            $url = asset('storage/user/profile/'.$fileName); 
            $requestData['photo'] = "$url";            
        }else{
            $requestData['photo'] = User::find($user['id'])->photo;
        }
     
        if(User::updateProfile($requestData)){
            return redirect()->route('web.dashboard')->with('success', 'Profile updated successfully');
        }else{
            return redirect()->route('web.update-profile')->with('error', 'Something went wrong, please try again');
        }
        
       
    }

    public function invest_pool(Request $request){
        $user = Auth::user();
        $input = $request->all();

        if($input['amount'] <= $user['wallet_balance']){

            $pool_data = Pool::where('id',$input['pool_id'])->first();
        
            if($pool_data['min_amount'] <= $input['amount'] && $pool_data['max_amount'] >= $input['amount']){
                $data = [
                    'user_id' => $user->id,
                    'pools_id' => $input['pool_id'],
                    'coin'=>$input['amount'],
                    'title'=>'pool_invest', 
                    'display_text'=>"Pool Invest",
                    'type'=>"debited",
                    'date'=>date('Y-m-d'),
                    'status'=>'pending'
                ];
        
                $history = WalletHistory::create($data);
        
                $wallet__amount = $user['wallet_balance'] - $input['amount'];
                $update_user_wallet = User::where('id',$user->id)->update(['wallet_balance'=>$wallet__amount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
    
                $result = ['status' =>'true'];
                // $result = 'true';
                return $result;

            }else{

                $result = ['status' =>'min_max',
                    'min_amount' => $pool_data['min_amount'],
                    'max_amount' => $pool_data['max_amount'],
                ];
                return $result;
            }
            
        }else{

            $result = ['status' =>'insufficient_balance'];
            return $result;
        }
    }

    public function pool_history(Request $request){
        $user = Auth::user();
        $wallet_data = User::select('wallet_balance','wallet_update_date')->where('id',$user->id)->first();
        $wallet_data['wallet_update_date'] = $this->timeago($wallet_data['wallet_update_date']);

        $getWalletHistory = WalletHistory::where('title','=','pool_invest')->where('user_id',$user->id)->orderBy('id','desc')->paginate(10);
        foreach($getWalletHistory as $key=>$data){
            $pool_name = Pool::where('id',$data['pools_id'])->first();

            $getWalletHistory[$key]['pool_name'] = $pool_name['name'];
            $getWalletHistory[$key]['date'] = date('d/m/Y',strtotime($data['date']));
        }
        return view('web.pool-history')->with(['wallet_balance'=>$wallet_data,'user'=>$user, 'get_wallet_history'=>$getWalletHistory]);
    }

    public function referral_history(Request $request){
        $user = Auth::user();
        
        $wallet_data = User::select('wallet_balance','wallet_update_date')->where('id',$user->id)->first();
        $wallet_data['wallet_update_date'] = $this->timeago($wallet_data['wallet_update_date']);

        $referred_users = User::where('refferal_from',$user->id)->paginate(10);    
        foreach($referred_users as $key=>$rf){
            $wallet_history = WalletHistory::where('title','=','referral_commision')->where('user_id',$user->id)->where('source_id',$rf['id'])->sum('coin');
            $referred_users[$key]['referral_amount'] = $wallet_history;
        }

        return view('web.referral-history')->with(['wallet_balance'=>$wallet_data,'user'=>$user, 'referred_users'=>$referred_users]);
    }

    public function all_plan(Request $request){
        $user = Auth::user();
        $wallet_data = User::select('wallet_balance','wallet_update_date')->where('id',$user->id)->first();
        $wallet_data['wallet_update_date'] = $this->timeago($wallet_data['wallet_update_date']);

        $plan_data = Plan::where('status','=','active')->get()->toArray();
        return view('web.plan-list')->with(['wallet_balance'=>$wallet_data,'user'=>$user, 'plan_data'=>$plan_data]);
    }

    public function plan_purchase_old(Request $request){
      
        $input = $request->all();
    
        //check referrered user count
        $user = Auth::user();
       
        $get_plan_data = Plan::where('id',$input['plan_id'])->first();
        $purchased_CardHistory = CardHistory::where('user_id',$user->id)->where('plan_id',$get_plan_data['id'])->first();
        
        if(!empty($purchased_CardHistory)){
            $expiry_date = $purchased_CardHistory['expiry_date'];
        }else{
        $expiry_date = ""; 
        }
        $today = date('Y-m-d');
     
        //  if($expiry_date < $today){
            
             if($user['wallet_balance'] >= $get_plan_data['coin']){
                
                 //get first level referral user
                 $get_ref_user_name = User::where('id',$user['refferal_from'])->first();
                 
                 if(!empty($get_ref_user_name)){
                     $get_ref_user_list = User::where('refferal_from',$get_ref_user_name['id'])->get()->toArray();
                     
                     $get_ref_user_firt = User::where('refferal_from',$get_ref_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
                 }else{
                     $get_ref_user_firt = "";
                 }
                     
             
                 //main user referral commision
                 if(!empty($get_ref_user_firt)){
                     foreach($get_ref_user_firt as $rf_data){
                         if($rf_data['id'] == $user->id){
     
                             $amount = ($get_plan_data['coin']*30)/100;
                     
                             //update wallet amount
                             $walletAmount = $get_ref_user_name['wallet_balance'] + $amount;
                             $update_wallet_balance = User::where('id',$get_ref_user_name['id'])->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
     
                             //add wallet history
                             $wallet_history = [
                                 'user_id' => $get_ref_user_name['id'],
                                 'source_id' => $rf_data['id'],
                                 'plan_id' => $input['plan_id'],
                                 'coin' => $amount,
                                 'title' => 'referral_commision',
                                 'display_text' => "Referral Commision",
                                 'type' => 'credited'
                             ];
                             $referral_history = WalletHistory::create($wallet_history);
                         }
                     }
                 }
     
                 if(!empty($get_ref_user_name) && !empty($get_ref_user_firt)){
     
                     $get_second_level_user_name = User::where('id',$get_ref_user_name['refferal_from'])->first();
                     
                     if(!empty($get_second_level_user_name)){
                         $get_second_ref_user_list = User::where('refferal_from',$get_second_level_user_name['id'])->get()->toArray();
                         $get_ref_user_second = User::where('refferal_from',$get_second_level_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
     
                     }else{
                         $get_second_ref_user_list = [];
                         $get_ref_user_second = [];
     
                     }
                     
                     
                     if(!empty($get_ref_user_second)){
                         // foreach($get_ref_user_second as $rs_data){
                             
                             $second_user = User::where('id',$get_ref_user_second[0]['refferal_from'])->first();
                             $amount_second = ($get_plan_data['coin']*10)/100;
                     
                             //update wallet amount
                             $walletAmount_second = $second_user['wallet_balance'] + $amount_second;
                             $update_wallet_balance = User::where('id',$second_user['id'])->update(['wallet_balance'=>$walletAmount_second, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
     
                             //add wallet history
                             $wallet_history_second = [
                                 'user_id' => $get_ref_user_second[0]['refferal_from'],
                                 'source_id' => $user->id,
                                 'plan_id' => $input['plan_id'],
                                 'coin' => $amount_second,
                                 'title' => 'referral_commision',
                                 'display_text' => "Referral Commision",
                                 'type' => 'credited'
                             ];
                             $referral_history = WalletHistory::create($wallet_history_second);
                         // }
                     }
     
                     if(!empty($get_second_level_user_name) && !empty($get_ref_user_second)){
                         $get_third_level_user_name = User::where('id',$get_second_level_user_name['refferal_from'])->first();
                         $get_third_ref_user_list = User::where('refferal_from',$get_third_level_user_name['id'])->get()->toArray();
                     
                         $get_ref_user_third = User::where('refferal_from',$get_third_level_user_name['id'])->skip(5)->take(5000)->orderBy('id', 'ASC')->get()->toArray();
                         
                         if(!empty($get_ref_user_third)){
                             // foreach($get_ref_user_third as $r_data){
     
                                 $third_user = User::where('id',$get_ref_user_third[0]['refferal_from'])->first();
                                 $amount = ($get_plan_data['coin']*5)/100;
                                 
                                 //update wallet amount
                                 $walletAmount = $third_user['wallet_balance'] + $amount;
                                 $update_wallet_balance = User::where('id',$third_user['id'])->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
     
                                 //add wallet history
                                 $wallet_history = [
                                     'user_id' => $third_user['id'],
                                     'source_id' => $user->id,
                                     'plan_id' => $input['plan_id'],
                                     'coin' => $amount,
                                     'title' => 'referral_commision',
                                     'display_text' => "Referral Commision",
                                     'type' => 'credited'
                                 ];
                                 $referral_history = WalletHistory::create($wallet_history);
                                 
                             // }
     
                         }
                     }
                     
                 }
     
                 //create purchase history
                 $ed = '+'.$get_plan_data['days'].' days';
                 $expiry_date = date('Y-m-d', strtotime($ed));
                 $data = [
                     'user_id'=>$user->id,
                     'plan_id'=>$input['plan_id'],
                     'title'=>"plan_purchase",
                     'display_text'=>"Plan Purchase",
                     'activated_date'=>date('Y-m-d'),
                     'expiry_date'=>$expiry_date,
                     'status'=>'active'
                 ];
                 $plan_history = CardHistory::create($data);
     
                 //update user wallet
                 $amount_updated = $user->wallet_balance - $get_plan_data['coin'];
                 $user_bUdate = User::where('id',$user->id)->update(['wallet_balance' => $amount_updated, 'wallet_update_date'=>date('Y-m-d')]);
                //  return $this->sendResponse($plan_history, 'Plan purchase successfully!');

                $result = 'true';
                return $result;
     
             }else{
            
                $result = 'insufficient_balance';
                return $result;
            //    return $this->sendError('Error', ['error'=>"Please Add Fund To Your Wallet!"]);
             }
        //  }else{
        //      // return $this->sendResponse("", 'Plan already purchase!');

        //     $result = 'already_purchase';
        //     return $result;
        //     // return $this->sendError('Error', ['error'=>"Plan already purchase!"]);
        //  }
    }

    public function plan_purchase(Request $request){
      
        $input = $request->all();
    
        //check referrered user count
        $user = Auth::user();
       
        $get_plan_data = Plan::where('id',$input['plan_id'])->first();
        $purchased_CardHistory = CardHistory::where('user_id',$user->id)->where('plan_id',$get_plan_data['id'])->first();
        
        if(!empty($purchased_CardHistory)){
            $expiry_date = $purchased_CardHistory['expiry_date'];
        }else{
            $expiry_date = ""; 
        }
        $today = date('Y-m-d');
     
        if($user['wallet_balance'] >= $get_plan_data['coin']){
            $amount = ($get_plan_data['coin']*30)/100;
            $plan_id = $input['plan_id'];
            
            // Calculate commissions
            User::calculateCommissions($user, $amount, $plan_id);

            //create purchase history
            $ed = '+'.$get_plan_data['days'].' days';
            $expiry_date = date('Y-m-d', strtotime($ed));
            $data = [
                'user_id'=>$user->id,
                'plan_id'=>$input['plan_id'],
                'title'=>"plan_purchase",
                'display_text'=>"Plan Purchase",
                'activated_date'=>date('Y-m-d'),
                'expiry_date'=>$expiry_date,
                'status'=>'active'
            ];
            $plan_history = CardHistory::create($data);

            //update user wallet
            $amount_updated = $user->wallet_balance - $get_plan_data['coin'];
            $user_bUdate = User::where('id',$user->id)->update(['wallet_balance' => $amount_updated, 'wallet_update_date'=>date('Y-m-d')]);
        //  return $this->sendResponse($plan_history, 'Plan purchase successfully!');

            $result = 'true';
            return $result;

        }else{

            $result = 'insufficient_balance';
            return $result;
        //    return $this->sendError('Error', ['error'=>"Please Add Fund To Your Wallet!"]);
        }
      
    }

    public function teamList(Request $request)
    {
        $level = $request->input('level');
        $user = Auth::user();
        $wallet_data = User::select('wallet_balance','wallet_update_date')->where('id',$user->id)->first();
        $wallet_data['wallet_update_date'] = $this->timeago($wallet_data['wallet_update_date']);
        
        // Get referred users up to level 5
        $referredUsers = $user->getReferredUsersAtLevel();
    
        // Filter referred users if a specific level is selected
        if ($level) {
            $referredUsers = $referredUsers->where('level', $level);
        }
    
        return view('web.team')->with(['wallet_balance' => $wallet_data, 'user' => $user, 'referredUsers' => $referredUsers]);
    }
    

    public function adList(Request $request){
        $user = Auth::user();
        $today = date('Y-m-d');
        $getWalletHistory = WalletHistory::select('ad_id')->where('user_id',$user->id)->whereDate('date','=',$today)->where('title','watch_add')->get()->toArray();

        $data = Ad::whereNotIn('id',$getWalletHistory)->whereDate('date','=',$today)->where('status','=','active')->get()->toArray();
        return view('web.ad_list')->with(['video_data'=>$data, 'user'=>$user]);
    }

    public function showAdd($id)
    {
        $video = Ad::findOrFail($id);
        $skipTimeSetting = Setting::where('config_key', 'skip_video_time')->first();
        $skipTime = $skipTimeSetting ? (int) $skipTimeSetting->config_value : 10; // Convert to integer and set default skip time
        
        return view('web.video-show', compact('video', 'skipTime'));
    }

    public function adWatch(Request $request) {
       
        $input = $request->all();
        $user = Auth::user();
        $video_data = Ad::where('id',$input['video_id'])->first();
  
        if(!empty($video_data)){

            $data = [
                'user_id' => $user->id,
                'ad_id' => $input['video_id'],
                'coin' => $video_data['coin'],
                'title'=> "watch_add",
                'display_text' => "Daily AD Reward",
                'type'=>"credited",
                'date'=>date('Y-m-d'),
                'status'=>'success',
            ];
    
            $walletHistory = WalletHistory::create($data);

            //update wallet amount
            $walletAmount = $user['wallet_balance'] + $video_data['coin'];
            $update_wallet_balance = User::where('id',$user->id)->update(['wallet_balance'=>$walletAmount, 'wallet_update_date'=>date("Y-m-d h:i:s")]);
            // return $this->sendResponse([$walletHistory], 'Claim successfully!');
            $result = 'true';
            return $result;

        }else{
            $result = 'false';
            return $result;
        }
    }

    public function storeToken(Request $request)
    {
        auth()->user()->update(['fcm_token'=>$request->token]);
        return response()->json(['Token successfully stored.']);
    }

}
