<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Lead;
use Illuminate\Support\Str;

class UserLeadController extends Controller
{
    public function lead_list(Request $request){       
        
        $leads = Lead::orderBy('id', 'desc')->get()->toArray();
        return view('web.lead_list')->with(['leads'=>$leads]);
    }

    public function add(Request $request) {
        if ($request->isMethod('post')) {

            $requestData = $request->all();

            $data = [
                'name'=>$requestData['name'],
                'email'=>$requestData['email'],
                'mobile'=>$requestData['mobile'],
                'college_name'=> $requestData['college_name'],
                'status'=>'pending'
            ];
           
            $result = Lead::createLead($data);
            if($result){
               return redirect()->route('web.lead-list')->with('success', 'Lead added successfully!');
            }else{
                return redirect()->route('web.lead.add')->with('error', 'Something went wrong, please try again');
            }
        }
        return view('web.lead_add');
    }

}
