<?php


namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Hash;
use Auth;
use Illuminate\Support\Str;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use App\Models\Course;
// use App\Models\Otp;

class UserLoginController extends Controller
{
    public function payment(Request $request) {
   
        return view('web.payment');
    }
    
    public function signUp(Request $request) {
        $url = $_SERVER['REQUEST_URI'];
        $code = explode('=', $url);
        $r_code = end($code);

        if($r_code != '/sign-up'){
            $ref_code = $r_code;
        }else{
            $ref_code = "";
        }

        $getCourse = Course::where('status','=','active')->get();
        return view('web.register')->with(['code'=>$ref_code, 'getCourse'=>$getCourse]);
    }

    public function signUpUserSave(Request $request) {
        $input = $request->all();

        $rules = [       
            'name' => 'required',         
            'email' =>  'required|email|unique:users',
            'password' => 'required',
            'college_name' => 'required',
            'course_id' => 'required'
            // 'refferal_from' => 'required'        
        ];

        $customMessages = [
            'required' => 'The field is required.',
        ];

        $niceNames = array();
        $this->validate($request, $rules, $customMessages, $niceNames);

        $referral =rand('10000000','99999999');
        $input['password'] = Hash::make($input['password']);

        if(isset($input['refferal_from']) && $input['refferal_from'] != ""){
            $referral___input = $input['refferal_from'];
            
            //check referral code is valid or not
            $ref_code = $referral___input;
            $get_ref_code = User::where('unique_id','=',$ref_code)->first();
            if(!empty($get_ref_code)){
                $refer_from = $get_ref_code['id']; 
            }else{
                // $refer_from = "";
                return redirect()->back()->with('error', 'Invalid Referral Code!');
            }
        }else{
            $refer_from = "0";
        }

        $data = [
            'name' => $input['name'],
            'email'=>$input['email'],
            'password'=>$input['password'], 
            'college_name'=>$input['college_name'],
            'course_id'=>$input['course_id'],
            'unique_id'=>$referral,
            'refferal_from'=>$refer_from,
            'status'=>'in-active',
        ];
        $user = User::create($data);
        
        return redirect()->route('web.login')->with(['success'=>'User registered successfully!']);
    }

    public function validateLogin(Request $request) {

        $rules = [            
            'email' =>  'required',
            'password' => 'required'   
        ];

        $customMessages = [
            'required' => 'The field is required.',
        ];

        $niceNames = array();
        $this->validate($request, $rules, $customMessages, $niceNames);
 
            $username = $request->email; 
            $password = $request->password;
            $remember = $request->has('remember') ? true : false;
            
            if(filter_var($username, FILTER_VALIDATE_EMAIL)) {
              
                //user sent their email 
                Auth::attempt(['email' => $username, 'password' => $password, 'user_type' => '2'],$remember);
            }else if(is_numeric($username)){
             
                //they sent their mobile instead 
                Auth::attempt(['mobile' => $username, 'password' => $password, 'user_type' => '2'],$remember);
            }else{
              
                //they sent their username instead 
                Auth::attempt(['name' => $username, 'password' => $password, 'user_type' => '2'],$remember);
            }
            
            //was any of those correct ?
            if ( Auth::check() ) {
                
                $user = Auth::user();
                $message = "";
                //send them where they are going 
                return redirect()->route('web.dashboard')->with(['success'=>'Welcome to dashboard!']);
            }
            /*
             * This code for check only using username
             * $credentials = $request->only('username', 'password');
    
            if (Auth::attempt($credentials)) {
                return redirect()->route('admin.home')->with('status', 'You are logged in!');
            }*/
   
            return redirect()->route('web.login')->with('error', 'Oops! You have entered invalid credentials');
            // return redirect()->route('web.login')->with('error', ' You are disqualified!');
    }

    public function logout() {
        
        if(Auth::check() && Auth::user()->user_type == '2'){
            Auth::logout();
            return redirect()->route('web.login')->with('logout', 'You are logged out!'); 
        }
    }
}
