<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
// use Illuminate\Mail\Mailables\Content;
// use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\User;

class UserSignupMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */

    protected $user;
    protected $otp;

    public function __construct(User $userData, $otp)
    {
        $this->user = $userData;
        $this->otp = $otp;
    }

    public function build()
    {
        return $this->view('mail.user-signup')->with(['userDetails'=>$this->user,'otp'=>$this->otp]);
    }
}
