<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\FcmNotificationService;

class Ad extends Model
{
    use FcmNotificationService;
    use HasFactory;
    use SoftDeletes;
    protected $guarded = [];

    protected function createAd($data){
     
        $ad = new Ad;
        $ad->title = $data['title'];
        $ad->video = $data['video'];
        $ad->date = $data['date'];
        $ad->coin = $data['coin'];
        $ad->status = $data['status'];
        $ad->save();

        // $notification_data = ['title'=>'Video Added!',
        //                       'message'=>'New AD Added You Can Watch!'  
        //                     ];

        // $moredata = ['title'=>'Video Added!',
        //     'message'=>'New AD Added You Can Watch!'  
        // ];
     
        //send notification to all user
        // $dataNew = User::where('user_type','2')->chunk(50, function ($users) use ($notification_data,$moredata) {
        //     foreach ($users as $user) {
            
        //         if($user['fcm_token'] != null){
        //             $this->sendFcmNotification($user['remember_token'],$notification_data);
        //         }
        //     }
        // });

        //new code
        // $user_data = User::where('user_type',2)->get()->toArray();
        // foreach($user_data as $uData) {
          
        //     if($uData['fcm_token'] != null){
        //         $this->sendFcmNotification($uData['fcm_token'],$notification_data,$moredata);
        //     }
        // }
        
        return $ad;
    } 

    protected function updateAds($data) {

        $ad = Ad::find($data['id']);
        $ad->title = $data['title'];
        $ad->video = $data['video'];
        $ad->date = $data['date'];
        $ad->coin = $data['coin'];
        $ad->status = $data['status'];

        if($ad->save()){
            return true;
        }
        return false;
    }

    protected function deleteAd($ad_id){
        if(Ad::where('id',$ad_id)->delete()){
            return true;
        }
        return false;
    }
}
