<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Course extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $guarded = [];

    protected function createCourse($data){
        $course = new Course;
        $course->name = $data['name'];
        $course->fees = $data['fees'];
        $course->duration = $data['duration'];
        $course->pdf = $data['pdf'];
        $course->status = $data['status'];
        $course->save();

        return $course;
    } 

    protected function updateCourse($data) {

        $course = Course::find($data['id']);
        $course->name = $data['name'];
        $course->fees = $data['fees'];
        $course->duration = $data['duration'];
        $course->pdf = $data['pdf'];
        $course->status = $data['status'];

        if($course->save()){
            return true;
        }
        return false;
    }

    protected function deleteCourse($course_id){
        if(Course::where('id',$course_id)->delete()){
            return true;
        }
        return false;
    }

}
