<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HomeBanner extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $guarded = [];

    protected function createHomeBanner($data) {  

        $homebanner = new HomeBanner;
        $homebanner->title = $data['title'];
        $homebanner->description = $data['description'];
        $homebanner->image = $data['image'];
        $homebanner->status = $data['status'];
        $homebanner->save();
        return $homebanner;
    }
    
    protected function updateHomebanner($data) {  

        $homebanner = HomeBanner::find($data['id']);
        $homebanner->title = $data['title'];
        $homebanner->description = $data['description'];
        $homebanner->image = $data['image'];
        $homebanner->status = $data['status'];

        if($homebanner->save()){
            return true;
        }
        return false;
    }

    protected function deleteHomebanner($banner_id){
        if(HomeBanner::where('id',$banner_id)->delete()){
            return true;
        }
        return false;
    }
}
