<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lead extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $guarded = [];

    protected function createLead($data){
        $lead = new Lead;
        $lead->name = $data['name'];
        $lead->email = $data['email'];
        $lead->mobile = $data['mobile'];
        // $lead->course_id = $data['course_id'];
        $lead->college_name = $data['college_name'];
        $lead->status = $data['status'];
        $lead->save();

        return $lead;
    } 

    protected function updateLead($data) {

        $lead = Lead::find($data['id']);
        $lead->name = $data['name'];
        $lead->email = $data['email'];
        $lead->mobile = $data['mobile'];
        // $lead->course_id = $data['course_id'];
        $lead->college_name = $data['college_name'];
        $lead->status = $data['status'];

        if($lead->save()){
            return true;
        }
        return false;
    }

    protected function deleteLead($lead_id){
        if(Lead::where('id',$lead_id)->delete()){
            return true;
        }
        return false;
    }
}
