<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Plan extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $guarded = [];

    protected function createPlan($data){
     
        $plan = new Plan;
        $plan->title = $data['title'];
        $plan->coin = $data['coin'];
        $plan->days = $data['days'];
        $plan->daily_revenue = $data['daily_revenue'];
        $plan->status = $data['status'];
        $plan->max_earn = $data['max_earn'];
        $plan->roi = $data['roi'];
        $plan->image = $data['image'];
        $plan->bg_plan_image = $data['bg_plan_image'];
        $plan->bg_card_image = $data['bg_card_image'];
        $plan->bg_plan_normal = $data['bg_plan_normal'];
        $plan->save();
        return $plan;
    } 


    protected function updatePlan($data) {  

        $plan = Plan::find($data['id']);
        $plan->title = $data['title'];
        $plan->coin = $data['coin'];
        $plan->days = $data['days'];
        $plan->daily_revenue = $data['daily_revenue'];
        $plan->status = $data['status'];
        $plan->max_earn = $data['max_earn'];
        $plan->roi = $data['roi'];
        $plan->image = $data['image'];
        $plan->bg_plan_image = $data['bg_plan_image'];
        $plan->bg_card_image = $data['bg_card_image'];
        $plan->bg_plan_normal = $data['bg_plan_normal'];

        if($plan->save()){
            return true;
        }
        return false;
    }

    protected function deletePlan($plan_id){
        if(Plan::where('id',$plan_id)->delete()){
            return true;
        }
        return false;
    }
}
