<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pool extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $guarded = [];

    protected function createPool($data){
     
        $pool = new Pool;
        $pool->name = $data['name'];
        $pool->days = $data['days'];
        $pool->min_amount = $data['min_amount'];
        $pool->max_amount = $data['max_amount'];
        $pool->percent = $data['percent'];
        $pool->time = $data['time'];
        $pool->status = $data['status'];
        $pool->save();
        return $pool;
    } 


    protected function updatePool($data) {  

        $pool = Pool::find($data['id']);
        $pool->name = $data['name'];
        $pool->days = $data['days'];
        $pool->min_amount = $data['min_amount'];
        $pool->max_amount = $data['max_amount'];
        $pool->percent = $data['percent'];
        $pool->time = $data['time'];
        $pool->status = $data['status'];;

        if($pool->save()){
            return true;
        }
        return false;
    }

    protected function deletePool($pool_id){
        if(Pool::where('id',$pool_id)->delete()){
            return true;
        }
        return false;
    }
}
