<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
// use Laravel\Sanctum\HasApiTokens;
use Laravel\Passport\HasApiTokens;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Hash;
use Auth;
use App\Models\Commission;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    // protected $fillable = [
    //     'name',
    //     'email',
    //     'password',
    // ];

    protected $guarded = [];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function parent()
    {
        return $this->belongsTo(User::class, 'refferal_from');
    }

    public function children()
    {
        return $this->hasMany(User::class, 'refferal_from');
    }

    public function getAncestors($level = 5)
    {
        $ancestors = [];
        $parent = $this->parent;
        while ($parent && count($ancestors) < $level) {
            $ancestors[] = $parent;
            $parent = $parent->parent;
        }
        return $ancestors;
    }

    public static function calculateCommissions($user, $amount, $plan_id)
    {
        $ancestors = $user->getAncestors();
        foreach ($ancestors as $index => $ancestor) {
            $level = $index + 1;
            $commission = Commission::where('level', $level)->first();
            if ($commission) {
                $percentage = $commission->percentage;
                $commission_amount = ($percentage / 100) * $amount;

                // Store the commission in the wallet history
                $wallet_history = [
                    'user_id' => $ancestor->id,
                    'source_id' => $user->id,
                    'plan_id' => $plan_id,
                    'coin' => $commission_amount,
                    'title' => 'referral_commission',
                    'display_text' => "Referral Commission",
                    'type' => 'credited',
                    'date'=> date('Y-m-d'),
                ];
                WalletHistory::create($wallet_history);
            }
        }
        
    }

    protected function createUser($data) {  
      
        $user = new User;
        $user->name = $data['name'];
        $user->mobile = $data['mobile'];
        $user->email = $data['email'];
        $user->college_name = $data['college_name'];
        $user->course_id = $data['course_id'];
        $user->user_type = $data['user_type'];
        $user->password = $data['password'];
        $user->unique_id = $data['unique_id'];
        $user->photo = $data['image'];
        $user->refferal_from = $data['refferal_from'];
        // $user->is_verify = $data['is_verify'];
        $user->payment_status = $data['payment_status'];
        $user->certificate = $data['certificate'];
        $user->status = $data['status'];
        $user->save();
        return $user;
    }

    protected function updateUser($data) {  
        $user = User::find($data['id']);
        $user->name = $data['name'];
        $user->mobile = $data['mobile'];
        $user->photo = $data['image'];
        $user->college_name = $data['college_name'];
        $user->start_date = $data['start_date'];
        $user->end_date = $data['end_date'];
        $user->payment_status = $data['payment_status'];
        $user->status = $data['status'];

        if($user->save()){
            return true;
        }
        return false;
    }

    protected function deleteUser($user_id){
        if(User::where('id','=',$user_id)->delete()){
            return true;
        }
        return false;
    }

    protected function changeUserPassword($requestData){
        $user_auth = Auth::user();
        $user = User::find($user_auth['id']);
        
        $user->password = Hash::make($requestData['confirm_password']);            
        if($user->save()){
            return true;
        }else{
            return false;
        }
    }

    protected function updateProfile($requestData){
        $user_auth = Auth::user();
        $user = User::find($user_auth['id']);
        
        $user->name = $requestData['name'];
        $user->photo = $requestData['photo'];

        if($user->save()){
            return true;
        }else{
            return false;
        }
    }

    // Recursive function to get referred users up to 4 levels
    public function getReferredUsersAtLevel($level = 5, $currentLevel = 1)
    {
        if ($currentLevel > $level) {
            return collect([]);
        }

        $referredUsers = collect();

        foreach ($this->children as $user) {
            $user->level = $currentLevel;
            $referredUsers->push($user);

            // Recursively get referred users at the next level
            $referredUsers = $referredUsers->merge(
                $user->getReferredUsersAtLevel($level, $currentLevel + 1)
            );
        }
        return $referredUsers;
    }

}
