const handleThemeUpdate = (cssVars) => {
    const root = document.querySelector(':root');
    const keys = Object.keys(cssVars);
    keys.forEach(key => {
        root.style.setProperty(key, cssVars[key]);
    });
}

// to check the value is hexa or not
const isValidHex = (hexValue) => /^#([A-Fa-f0-9]{3,4}){1,2}$/.test(hexValue)

const getChunksFromString = (st, chunkSize) => st.match(new RegExp(`.{${chunkSize}}`, "g"))
// convert hex value to 256
const convertHexUnitTo256 = (hexStr) => parseInt(hexStr.repeat(2 / hexStr.length), 16)
// get alpha value is equla to 1 if there was no value is asigned to alpha in function
const getAlphafloat = (a, alpha) => {
    if (typeof a !== "undefined") { return a / 255 }
    if ((typeof alpha != "number") || alpha < 0 || alpha > 1) {
        return 1
    }
    return alpha
}
// convertion of hex code to rgba code
function hexToRgba(hexValue, alpha) {
    if (!isValidHex(hexValue)) { return null }
    const chunkSize = Math.floor((hexValue.length - 1) / 3)
    const hexArr = getChunksFromString(hexValue.slice(1), chunkSize)
    const [r, g, b, a] = hexArr.map(convertHexUnitTo256)
    return `rgba(${r}, ${g}, ${b}, ${getAlphafloat(a, alpha)})`
}

function dynamicPrimaryColor(primaryColor){
    primaryColor.forEach((item) => {
		item.addEventListener('input', (e) => {
			const cssPropName = `--volgh-${e.target.getAttribute('data-id')}`;
			const cssPropName1 = `--volgh-${e.target.getAttribute('data-id1')}`;
			const cssPropName2 = `--volgh-${e.target.getAttribute('data-id2')}`;
			const cssPropName7 = `--volgh-${e.target.getAttribute('data-id7')}`;
			handleThemeUpdate({
				[cssPropName]: hexToRgba(e.target.value),
				 // 95 is used as the opacity 0.95
				[cssPropName1]:  hexToRgba(e.target.value, 0.99),
				[cssPropName2]: hexToRgba(e.target.value, 0.2),
				[cssPropName7]: hexToRgba(e.target.value, 0.2),
			});
		});
	});
}
function dynamicBackgroundColor(bgColor){
    bgColor.forEach((item) => {
		item.addEventListener('input', (e) => {
			const cssPropName5 = `--volgh-${e.target.getAttribute('data-id5')}`;
			const cssPropName6 = `--volgh-${e.target.getAttribute('data-id6')}`;
			handleThemeUpdate({
				[cssPropName5]: hexToRgba(e.target.value, 0.86),
				 // 95 is used as the opacity 0.95
				[cssPropName6]: e.target.value ,
			});
		});
	});
}

(function () {
	// Light theme color picker
	const dynamicPrimaryLight = document.querySelectorAll('input.color-primary-light');
	const dynamicBackground = document.querySelectorAll('input.color-bg-transparent');
    dynamicPrimaryColor(dynamicPrimaryLight);
    dynamicBackgroundColor(dynamicBackground);
	localStorageBackup();
})();

function localStorageBackup(){
	// if there is a value stored, update color picker and background color
	// Used to retrive the data from local storage
	if (localStorage.volghprimaryColor) {
		document.querySelector('html').style.setProperty('--volgh-primary', localStorage.volghprimaryColor);
		document.querySelector('html').style.setProperty('--volgh-primary-hover', localStorage.volghprimaryHoverColor);
		document.querySelector('html').style.setProperty('--volgh-primary-border', localStorage.volghprimaryBorderColor);
	}
	if(localStorage.volghlightMode){
        document.querySelector('body').classList.remove('dark-mode');
        document.querySelector('body').classList.add('light-mode')
    }
	if(localStorage.volghdarkMode){
        document.querySelector('body').classList.add('dark-mode');
        document.querySelector('body').classList.remove('light-mode')
    }
    if(localStorage.volghhorizontal){
        document.querySelector('body').classList.add('horizontal')
    }
    if(localStorage.volghhorizontalHover){
        document.querySelector('body').classList.add('horizontal-hover')
    }
    if(localStorage.volghrtl){ 
        document.querySelector('body').classList.add('rtl');
    }
	if (localStorage.volghdarkBody) {
		document.querySelector('html').style.setProperty('--volgh-dark-theme', localStorage.volghdarkTheme);
		document.querySelector('html').style.setProperty('--volgh-dark-background', localStorage.volghdarkBody);
        document.querySelector('body').classList.add('dark-mode');
        document.querySelector('body').classList.remove('light-mode');
		$('#myonoffswitch2').prop('checked', true);
	}
}

function changePrimaryColor() {

	let userColor = document.getElementById('colorID').value;
	localStorage.setItem('volghprimaryColor', userColor);
	// to store value as opacity 0.95 we use 95
	localStorage.setItem('volghprimaryHoverColor', userColor + 99);
	localStorage.setItem('volghprimaryBorderColor', userColor + 20);
	names()
}

function transparentBgColor() {
	let userColor1 = document.getElementById('transparentBgColorID').value;
	localStorage.setItem('volghdarkTheme', userColor1);
	localStorage.setItem('volghdarkBody', userColor1 + "dd");
	names()
	document.querySelector('body').classList.add('dark-mode');
 	document.querySelector('body').classList.remove('light-mode')
	 $('#myonoffswitch2').prop('checked', true);
}
// chart colors
let myVarValue, myVarValue2, myVarValue3, myVarVal, myVarVal1
function names(){

	//get variable
	myVarValue  =  localStorage.getItem("volghprimaryColor") || "#5e2dd8";
	myVarValue2 =  hexToRgba(localStorage.getItem("volghprimaryColor"),0.8)  || null;
	myVarValue3 = hexToRgba(localStorage.getItem("volghprimaryColor"), 0.5)
	myVarVal  =  localStorage.getItem("volghprimaryColor") || "#5e2dd8";
	myVarVal1 =  hexToRgba(localStorage.getItem("volghprimaryColor"),0.8)  || null;

	if(document.querySelector('#echart1') !== null){
		echart1();
	}

	let colorData1 = hexToRgba(myVarValue || "#5e2dd8", 0.2)
	document.querySelector('html').style.setProperty('--primary02', colorData1);

	let colorData2 = hexToRgba(myVarValue || "#5e2dd8", 0.5)
	document.querySelector('html').style.setProperty('--primary05', colorData2);

	let colorData3 = hexToRgba(myVarValue || "#5e2dd8", 0.1)
	document.querySelector('html').style.setProperty('--primary01', colorData3);

	let colorData9 = hexToRgba(myVarValue || "#5e2dd8", 0.9)
	document.querySelector('html').style.setProperty('--primary09', colorData9);

	let colorData05 = hexToRgba(myVarValue || "#5e2dd8", 0.05)
	document.querySelector('html').style.setProperty('--primary005', colorData05);
}
names()
