
@extends('admin.layout.main')
@section('content')

		<!-- GLOBAL-LOADER -->
		<div id="global-loader">
			<img src="../assets/images/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /GLOBAL-LOADER -->

		<!-- PAGE -->
	

                <!--app-content open-->
				<div class="app-content main-content">
					<div class="side-app">

						<div class="main-container">

						<!-- PAGE-HEADER -->
						<div class="page-header">
							<!-- <div>
								<h1 class="page-title">Table</h1>
								<ol class="breadcrumb">
									<li class="breadcrumb-item"><a href="#">Tables</a></li>
									<li class="breadcrumb-item active" aria-current="page">Table</li>
								</ol>
							</div> -->
						</div>
						<!-- PAGE-HEADER END -->

					

						<!-- ROW-2 -->
						<div class="row">
							<div class="col-12">
								<div class="card">
									@if (session('success'))
										<div class="alert alert-success" role="alert">
											{{ session('success') }}
										</div>
									@endif  
									
									<div class="card-header bg-transparent border-0">
										<h3 class="card-title">Home Banner Table</h3>
									</div>
									<div class="">
										<div class="grid-margin">
											<div class="">
												<div class="table-responsive">
                                                <a class="btn btn-info" href="{{route('admin.home-banner.add')}}" id="createNew"> Add New Home Banner</a>
													<table class="table card-table table-vcenter text-nowrap align-items-center data-table">
														<thead class="thead-light">
															<tr>
                                                                <th>No</th>
                                                                <th>Title</th>
                                                                <th>Image</th>
                                                                <th>status</th>
                                                                <th width="100px">Action</th>
															</tr>
														</thead>
														<tbody>

															@foreach($bannerData as $data)
																
																<tr>
																	<td>{{ $data['id'] }}</td>
																	<td>{{ $data['title'] }}</td>
                                                                    <td><img src="{{$data['image']}}" height="100px" width="180px"></img></td>
																	<td>{{ ucfirst($data['status']) }}</td>
																	<td class="v-align-middle">
																		<div class="btn-group act-btn-grup">
																			<a href="{{route('admin.home-banner.edit',['id'=>$data['id']])}}">
																				<button type="button" class="edit btn btn-primary btn-sm editBanner" Title="Edit Banner">Edit
																				</button>
																			</a>
																			<a href="{{route('admin.home-banner.deleteSingle',['id'=>$data['id']])}}">
																				<button type="button" class="btn btn-danger btn-sm deleteBanner" title="Delete Banner" onclick="return confirm('Are you sure to you want to delete this record?')">Delete
																				</button>
																			</a>
																	</td>
																</tr>
															@endforeach
															
														</tbody>
													</table>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<!-- ROW-2 CLOSED -->

					</div>
				</div>
				<!-- CONTAINER CLOSED -->
			</div>
            </div>
@endsection
 <!-- JQUERY JS -->
<script src="{{asset('js/jquery.min.js')}}"></script>

<script type="text/javascript">
    $(function () {
        var table = $('.data-table').DataTable();
    });
</script>

		