
@extends('admin.layout.main')
@section('content')
		<!-- GLOBAL-LOADER -->
		<div id="global-loader">
			<img src="../assets/images/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /GLOBAL-LOADER -->

		<!-- PAGE -->
			
                <!--app-content open-->
				<div class="app-content main-content">
					<div class="side-app">

						<div class="main-container">

						<!-- PAGE-HEADER -->
						<div class="page-header">
							<div>
								<h1 class="page-title">Add Plan</h1>
								<ol class="breadcrumb">
									<li class="breadcrumb-item"><a href="#">Main</a></li>
									<li class="breadcrumb-item active" aria-current="page">Add Plan</li>
								</ol>
							</div>
						</div>
						<!-- PAGE-HEADER END -->

						<!-- ROW-1 OPEN -->
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="card-title">Add Plan</div>
                                    </div>
                                    <div class="card-body">
                                        <form autocomplete="off" role="form" id="saveForm" action="{{route('admin.plan.save')}}" method="POST" enctype="multipart/form-data">
                                        @csrf

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Title :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="title" class="form-control" placeholder="User Name" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Coin :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="coin" class="form-control" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Days :</label>
                                                <div class="col-md-9">
                                                    <input type="number" name="days" class="form-control" placeholder="Plan" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Daily Revenue :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="daily_revenue" class="form-control" placeholder="Daily Revenue" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Max Earn :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="max_earn" class="form-control" placeholder="Max Earn" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">ROI :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="roi" class="form-control" placeholder="ROI" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Plan Image :</label>
                                                <div class="col-md-9 file-upload">
                                                        <div class="col-md-9 file-select">
                                                            <input type="file" name="image" id="image" accept=".png, .jpg, .jpeg">                                                      
                                                        </div>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Bg Plan Image :</label>
                                                <div class="col-md-9 file-upload">
                                                    <div class="col-md-9 file-select">
                                                        <input type="file" name="bg_plan_image" id="bg_plan_image" accept=".png, .jpg, .jpeg">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Bg Card Image :</label>
                                                <div class="col-md-9 file-upload">
                                                        <div class="col-md-9 file-select">
                                                            <input type="file" name="bg_card_image" id="bg_card_image" accept=".png, .jpg, .jpeg">
                                                        </div>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Bg Plan Normal :</label>
                                                <div class="col-md-9 file-upload">
                                                    <div class="col-md-9 file-select">
                                                        <input type="file" name="bg_plan_normal" id="bg_plan_normal" accept=".png, .jpg, .jpeg">
                                                    </div>
                                                </div>
                                            </div>
                                        
                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Status :</label>
                                                <div class="col-md-9">
                                                    <select name="status" class="form-control form-select select2" data-bs-placeholder="Select Status">
                                                        <option value="active">Active</option>
                                                        <option value="in-active">In-Active</option>
                                                </select>
                                                </div>
                                            </div>
                                    </div>

                                    <div class="card-footer">
                                        <!--Row-->
                                        <div class="row">
                                            <div class="col-md-3"></div>
                                            <div class="col-md-9">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                <a class="btn btn-default float-end" href='{{route('admin.plan.list')}}'>
                                                    Close
                                                </a>
                                               
                                            </div>
                                        </div>
                                        <!--End Row-->
                                    </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- /ROW-1 CLOSED -->

					</div>
					<!-- CONTAINER CLOSED -->
				</div>
			</div>	
		<!-- </div> -->
@endsection
		