
@extends('admin.layout.main')
@section('content')
		<!-- GLOBAL-LOADER -->
		<div id="global-loader">
			<img src="../assets/images/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /GLOBAL-LOADER -->

		<!-- PAGE -->
			
                <!--app-content open-->
				<div class="app-content main-content">
					<div class="side-app">

						<div class="main-container">

						<!-- PAGE-HEADER -->
						<div class="page-header">
							<div>
								<h1 class="page-title">Add Pool</h1>
								<ol class="breadcrumb">
									<li class="breadcrumb-item"><a href="#">Main</a></li>
									<li class="breadcrumb-item active" aria-current="page">Add Pool</li>
								</ol>
							</div>
						</div>
						<!-- PAGE-HEADER END -->

						<!-- ROW-1 OPEN -->
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="card-title">Add Pool</div>
                                    </div>
                                    <div class="card-body">
                                        <form autocomplete="off" role="form" id="saveForm" action="{{route('admin.pool.save')}}" method="POST" enctype="multipart/form-data">
                                        @csrf

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Name :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="name" class="form-control" placeholder="Name" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Days :</label>
                                                <div class="col-md-9">
                                                    <input type="number" name="days" class="form-control" placeholder="Days" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Min Amount :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="min_amount" class="form-control" placeholder="Min Amount" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Max Amount :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="max_amount" class="form-control" placeholder="Max Amount" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Percent :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="percent" class="form-control" placeholder="Percent" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Time :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="time" class="form-control" placeholder="Time" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Status :</label>
                                                <div class="col-md-9">
                                                    <select name="status" class="form-control form-select select2" data-bs-placeholder="Select Status">
                                                        <option value="active">Active</option>
                                                        <option value="in-active">In-Active</option>
                                                </select>
                                                </div>
                                            </div>
                                    </div>

                                    <div class="card-footer">
                                        <!--Row-->
                                        <div class="row">
                                            <div class="col-md-3"></div>
                                            <div class="col-md-9">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                <a class="btn btn-default float-end" href='{{route('admin.pool.list')}}'>
                                                    Close
                                                </a>
                                               
                                            </div>
                                        </div>
                                        <!--End Row-->
                                    </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- /ROW-1 CLOSED -->

					</div>
					<!-- CONTAINER CLOSED -->
				</div>
			</div>	
		<!-- </div> -->
@endsection
		