
@extends('admin.layout.main')
@section('content')
		<!-- GLOBAL-LOADER -->
		<div id="global-loader">
			<img src="../assets/images/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /GLOBAL-LOADER -->

		<!-- PAGE -->
			
                <!--app-content open-->
				<div class="app-content main-content">
					<div class="side-app">

						<div class="main-container">

						<!-- PAGE-HEADER -->
						<div class="page-header">
							<div>
								<h1 class="page-title">Add Student</h1>
								<ol class="breadcrumb">
									<li class="breadcrumb-item"><a href="#">Main</a></li>
									<li class="breadcrumb-item active" aria-current="page">Add Student</li>
								</ol>
							</div>
						</div>
						<!-- PAGE-HEADER END -->

						<!-- ROW-1 OPEN -->
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="card-title">Add Student</div>
                                    </div>
                                    <div class="card-body">
                                        <form autocomplete="off" role="form" id="saveForm" action="{{route('admin.user.save')}}" method="POST" enctype="multipart/form-data">
                                        @csrf

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">User Name :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="name" class="form-control" placeholder="User Name" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Email :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="email" class="form-control" placeholder="Email" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Mobile :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="mobile" class="form-control" placeholder="Mobile" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">College Name :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="college_name" class="form-control" placeholder="College Name" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Course :</label>
                                                <div class="col-md-9">
                                                    <select name="course_id" class="form-control form-select select2" data-bs-placeholder="Select Course" required>
                                                        <option value="">Select Course</option>
                                                        @foreach(App\Models\Course::select('id','name')->where('deleted_at','=',null)->Where('status','=','active')->orderBy('id','desc')->get() AS $parent)
                                                            <option onlyslave="true" value='{{$parent->id}}'>{{$parent->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Password :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="password" class="form-control" placeholder="Password" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Referral From :</label>
                                                <div class="col-md-9">
                                                    <select name="refferal_from" class="form-control form-select select2" data-bs-placeholder="Select User" required>
                                                        <option value="">Select User</option>
                                                        @foreach(App\Models\User::select('id','name')->where('user_type','=','2')->where('deleted_at','=',null)->Where('status','=','active')->orderBy('id','desc')->get() AS $parent)
                                                            <option onlyslave="true" value='{{$parent->id}}'>{{$parent->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Image :</label>
                                                <div class="col-md-9 file-upload">
                                                    <div class="col-md-9 file-select">
                                                        <input type="file" name="image" id="image" accept=".png, .jpg, .jpeg">
                                                        
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Payment Status :</label>
                                                <div class="col-md-9">
                                                    <select name="payment_status" class="form-control form-select select2" data-bs-placeholder="Select Payment Status">
                                                        <option value="pending">Pending</option>
                                                        <option value="completed">Completed</option>
                                                </select>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Upload Certificate :</label>
                                                <div class="col-md-9 file-upload">
                                                    <div class="col-md-9 file-select">
                                                        <input type="file" name="certificate" id="certificate">
                                                    </div>
                                                </div>
                                            </div>
                                        
                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Status :</label>
                                                <div class="col-md-9">
                                                    <select name="status" class="form-control form-select select2" data-bs-placeholder="Select Status">
                                                        <option value="active">Active</option>
                                                        <option value="in-active">In-Active</option>
                                                </select>
                                                </div>
                                            </div>
                                    </div>

                                    <div class="card-footer">
                                        <!--Row-->
                                        <div class="row">
                                            <div class="col-md-3"></div>
                                            <div class="col-md-9">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                <a class="btn btn-default float-end" href='{{route('admin.user.list')}}'>
                                                    Close
                                                </a>
                                               
                                            </div>
                                        </div>
                                        <!--End Row-->
                                    </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- /ROW-1 CLOSED -->

					</div>
					<!-- CONTAINER CLOSED -->
				</div>
			</div>	
		<!-- </div> -->
@endsection
		