
@extends('admin.layout.main')
@section('content')

		<!-- GLOBAL-LOADER -->
		<div id="global-loader">
			<img src="../assets/images/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /GLOBAL-LOADER -->

		<!-- PAGE -->
	

                <!--app-content open-->
				<div class="app-content main-content">
					<div class="side-app">

						<div class="main-container">

						<!-- PAGE-HEADER -->
						<div class="page-header">
							<!-- <div>
								<h1 class="page-title">Table</h1>
								<ol class="breadcrumb">
									<li class="breadcrumb-item"><a href="#">Tables</a></li>
									<li class="breadcrumb-item active" aria-current="page">Table</li>
								</ol>
							</div> -->
						</div>
						<!-- PAGE-HEADER END -->

    

						<!-- ROW-2 -->
						
                        <!-- Nav tabs -->
                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">Deposit History</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">Withdrawal History</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="messages-tab" data-bs-toggle="tab" data-bs-target="#messages" type="button" role="tab" aria-controls="messages" aria-selected="false">Wallet History</button>
                                </li>
                        
                            </ul>

                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div class="tab-pane active" id="home" role="tabpanel" aria-labelledby="home-tab">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="card">
                                                @if (session('success'))
                                                    <div class="alert alert-success" role="alert">
                                                        {{ session('success') }}
                                                    </div>
                                                @endif  
                                                
                                                <div class="card-header bg-transparent border-0">
                                                    <h3 class="card-title">Diposit History</h3>
                                                </div>
                                                <div class="">
                                                    <div class="grid-margin">
                                                        <div class="">
                                                            <div class="table-responsive">
                                                                <table class="table card-table table-vcenter text-nowrap align-items-center data-table">
                                                                    <thead class="thead-light">
                                                                        <tr>
                                                                            <th>No</th>
                                                                            <th>User Name</th>
                                                                            <th>Wallet Balance</th>
                                                                            <th>Coin</th>
                                                                            <th>Text</th>
                                                                            <th>Date</th>
                                                                            <th>Status</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>

                                                                        @foreach($deposit_history as $data)

                                                                            <?php
                                                                                $user_name = App\Models\User::where('id',$data['user_id'])->first();
                                                                            ?>

                                                                            <tr>
                                                                                <td>{{ $data['id'] }}</td>
                                                                                <td>{{ $user_name['name'] }}</td>
                                                                                <td>{{$user_name['wallet_balance']}}</td>
                                                                                <td>{{ $data['coin'] }}</td>
                                                                                <td>{{ $data['display_text'] }}</td>
                                                                                <td>{{ $data['date'] }}</td>
                                                                                <th>{{ ucfirst($data['status']) }}</th>
                                                                            </tr>
                                                                        @endforeach
                                                                        
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
						            </div>
                                </div>

                                <div class="tab-pane" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="card">
                                                @if (session('success'))
                                                    <div class="alert alert-success" role="alert">
                                                        {{ session('success') }}
                                                    </div>
                                                @endif  
                                                
                                                <div class="card-header bg-transparent border-0">
                                                    <h3 class="card-title">Withdrawal History</h3>
                                                </div>
                                                <div class="">
                                                    <div class="grid-margin">
                                                        <div class="">
                                                            <div class="table-responsive">
                                                                <table class="table card-table table-vcenter text-nowrap align-items-center data-table">
                                                                    <thead class="thead-light">
                                                                        <tr>
                                                                            <th>No</th>
                                                                            <th>User Name</th>
                                                                            <th>Withdrawal Address</th>
                                                                            <th>Wallet Balance</th>
                                                                            <th>Requested Coin</th>
                                                                            <th>Text</th>
                                                                            <th>Date</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>

                                                                        @foreach($withdrawal_history as $data)

                                                                            <?php

                                                                                $user_name = App\Models\User::where('id',$data['user_id'])->first();

                                                                                if($data['status'] == 'success'){
                                                                                    $p_status = 1;
                                                                                }else{
                                                                                    $p_status = 0;
                                                                                }
                                                                            ?>

                                                                            <tr>
                                                                                <td>{{ $data['id'] }}</td>
                                                                                <td>{{ $user_name['name'] }}</td>
                                                                                <td>{{ $data['withdrawal_address'] }}</td>
                                                                                <td>{{$user_name['wallet_balance']}}</td>
                                                                                <td>{{ $data['coin'] }}</td>
                                                                                <td>{{ $data['display_text'] }}</td>
                                                                                <td>{{ $data['date'] }}</td>

                                                                            </tr>
                                                                            @endforeach
                                                                        
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane" id="messages" role="tabpanel" aria-labelledby="messages-tab">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="card">
                                                @if (session('success'))
                                                    <div class="alert alert-success" role="alert">
                                                        {{ session('success') }}
                                                    </div>
                                                @endif  
                                                
                                                <div class="card-header bg-transparent border-0">
                                                    <h3 class="card-title">Wallet History</h3>
                                                </div>
                                                <div class="">
                                                    <div class="grid-margin">
                                                        <div class="">
                                                            <div class="table-responsive">
                                                                <table class="table card-table table-vcenter text-nowrap align-items-center data-table">
                                                                    <thead class="thead-light">
                                                                        <tr>
                                                                            <th>No</th>
                                                                            <th>User Name</th>
                                                                            <th>Source User Name</th>
                                                                            <th>Coin</th>
                                                                            <th>Text</th>
                                                                            <th>Date</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>

                                                                        @foreach($wallet_history as $data)

                                                                            <?php

                                                                                $user_name = App\Models\User::where('id',$data['user_id'])->first();
                                                                                $source_name = App\Models\User::where('id',$data['source_id'])->first();
                                                                                if(!empty($source_name)){
                                                                                    $s_name = $source_name['name'];
                                                                                }else{
                                                                                    $s_name = "-";
                                                                                }
                                                                            ?>

                                                                            <tr>
                                                                                <td>{{ $data['id'] }}</td>
                                                                                <td>{{ $user_name['name'] }}</td>
                                                                                <td>{{ $s_name}}</td>
                                                                                <td>{{$data['coin']}}</td>
                                                                                <td>{{ $data['display_text'] }}</td>
                                                                                <td>{{ $data['date'] }}</td>
                                                                            </tr>
                                                                            @endforeach
                                                                        
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        
                            </div>

						<!-- ROW-2 CLOSED -->

					</div>
				</div>
				<!-- CONTAINER CLOSED -->
			</div>
            </div>
@endsection
 <!-- JQUERY JS -->
<script src="{{asset('js/jquery.min.js')}}"></script>

<script type="text/javascript">
    $(function () {
        var table = $('.data-table').DataTable();
    });
</script>

		