
@extends('web.layout.main')
@section('content')

    <section class="faq_main">
        <div class="container">
            <div class="faq_wrapper">
                <div style="color:white;">Total Earning</div>
                <img src="{{asset('images/bg_wallet.png')}}" width="300" height="300">
                <div style="color:white; ">
              
                    ₹{{$wallet_balance['wallet_balance']}} <br/>
                    <span>{{$wallet_balance['wallet_update_date']}}</span>
                </div>
               
            </div>
        </div>
    </section>

    <section class="">

        <h2 style="padding-left: 100px; padding-top: 20px;color:white;">Wallet Transaction</h2>
        <div style="padding-left: 100px; padding-top: 20px;"><button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModal">
       Withdraw</button></div>

        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                <div class="modal-header">
                    <h2>Withdraw Request</h2>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div>
                        <label>Customer Name:</label>
                        <input type="text" name="customer_name" id="customer_name" placeholder="Customer Name">
                    </div><br/>

                    <div>
                        <label>Mobile:</label>
                        <input type="text" name="mobile" id="mobile" placeholder="mobile">
                    </div><br/>

                    <div>
                        <label>Bank Name:</label>
                        <input type="text" name="bank_name" id="bank_name" placeholder="Bank Name">
                    </div><br/>

                    <div>
                        <label>IFSC Code:</label>
                        <input type="text" name="ifsc_code" id="ifsc_code" placeholder="IFSC Code">
                    </div><br/>

                    <div>
                        <label>Amount:</label>
                        <input type="text" name="amount" id="amount" placeholder="Amount">
                    </div><br/>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="w_balance">Save</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    
                </div>
                </div>
            </div>
        </div>
    </section>


    <section class="faq_main">
        <div class="container">
            <div class="faq_wrapper">
                <h2 class="comman_small_head text-center">List Of Transaction</h2>
                <table class="table card-table table-vcenter text-nowrap align-items-center data-table" style="color:white;">
                    <thead class="thead-light">
                        <tr>
                            <th>Transaction</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
					
                    <tbody>

                        @foreach($get_wallet_history as $data)
                           
                            <tr>
                                <td>{{ $data['display_text'] }}</td>
                                <td>{{ $data['coin'] }}</td>
                            </tr>
                        @endforeach
                        
                    </tbody>
				</table>

            </div>
        </div>
    </section>

@endsection
    
<!-- <script src="http://code.jquery.com/jquery-1.9.1.min.js"></script> -->

<script src="{{asset('js/jquery.min.js')}}"></script>
      
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/css/toastr.css" rel="stylesheet"/>
        
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/js/toastr.js"></script>


<script>
  $(document).ready(function(){

        $('#w_balance').click(function(){

            var amount = $("#amount").val();
            var customer_name = $("#customer_name").val();
            var ifsc_code = $("#ifsc_code").val();
            var bank_name = $("#bank_name").val();
            var mobile = $("#mobile").val();
          
            if(amount == "" || customer_name == "" || ifsc_code == "" || bank_name == "" || mobile == ""){
                toastr.error("Please fill up all the fields!");
            }else{
                
                // AJAX request
                $.ajax({
                    url:  "<?= route('web.add-withdraw-request') ?>",
                    type: 'post',
                    dataType: "html",
                    data: { 
                            amount: amount,
                            customer_name: customer_name,
                            ifsc_code: ifsc_code,
                            bank_name: bank_name,
                            mobile: mobile,
                            _token: "{{ csrf_token() }}"
                          },
                    success: function(response){ 
                        if(response == 'true'){
                            // toastr.options.timeOut = 5000000;
                            toastr.success('Request sent successfully!');
                            location.reload(true);
                        }
                        if(response == 'false'){
                            toastr.error('You can not withdraw amount more than wallet balance!');
                        }
                    }
                });
            }
                     
        });
  
        $("#add_wallet_bln").keyup(function(){
                $("#add_wallet_bln").text( $("#add_wallet_bln").val());
        });

   });

</script>