<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Student Portal</title>
    <link rel="icon" href="{{asset('images/fav_icon_portal.png')}}">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
    integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous" />

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css" />

    <link rel="stylesheet" href="{{asset('css/style_web_dash.css')}}">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css" />
    <link href="https://cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/2.3.4/css/buttons.dataTables.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.4/js/dataTables.buttons.min.js"></script>

</head>

    <body>
        @include('web.layout.section.header')
        @yield('content')
        @include('web.layout.section.footer')
    </body>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"
  integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"
  integrity="sha384-cuYeSxntonz0PPNlHhBs68uyIAVpIIOZZ5JqeqvYYIcEL727kskC66kF92t6Xl2V" crossorigin="anonymous"></script>
  <script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>
  
  <!-- The core Firebase JS SDK is always required and must be listed first -->
  <script src="https://www.gstatic.com/firebasejs/8.3.2/firebase.js"></script>

  <script src="{{asset('js/custom_web.js')}}"></script>

  <script>
    $(document).ready(function(){
      // Existing code
      $('.toggle__event__btn').click(function(){
        $('.overlay__dropdown').slideToggle();
      });
  
      // Call startFCM when the document is ready
      startFCM();
    });
  
    function myFunction() {
        // var copyText = document.getElementById("myInput");
        // copyText.select();
        // copyText.setSelectionRange(0, 99999); // For mobile devices
        // navigator.clipboard.writeText(copyText.value);
  
      var temp = $("<input>");
      $("body").append(temp);
      temp.val($('#myInput').text()).select();
      document.execCommand("copy");
      temp.remove();
    }
  
    var firebaseConfig = {
        apiKey: 'AIzaSyDjomIDMBla-B9oSR0TozufhPTd0Qn2yvU',
        authDomain: 'helloastro24-c8619.firebaseapp.com',
        databaseURL: 'https://helloastro24-c8619-default-rtdb.firebaseio.com',
        projectId: 'helloastro24-c8619',
        storageBucket: 'helloastro24-c8619.appspot.com',
        messagingSenderId: '652883573767',
        appId: '1:652883573767:web:54b72ef2f8b44ad46fbea2',
        measurementId: 'G-YP77TSZ0ZF',
    };
  
    firebase.initializeApp(firebaseConfig);
    const messaging = firebase.messaging();
  
    function startFCM() {
        console.log("heyyyy");
        messaging
            .requestPermission()
            .then(function () {
                return messaging.getToken()
            })
            .then(function (response) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: '{{ route("store.token") }}',
                    type: 'POST',
                    data: {
                        token: response
                    },
                    dataType: 'JSON',
                    success: function (response) {
                        alert('Token stored.');
                    },
                    error: function (error) {
                        alert(error);
                    },
                });
  
            }).catch(function (error) {
                alert(error);
            });
    }
  
    messaging.onMessage(function (payload) {
        const title = payload.notification.title;
        const options = {
            body: payload.notification.body,
            icon: payload.notification.icon,
        };
        new Notification(title, options);
    });
  
  </script>
  

</html>