<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Portal</title>

    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{asset('css/style_web.css')}}">

    <!-- Bootstrap CSS CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9" crossorigin="anonymous">

    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"
        integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="icon" href="{{asset('images/fav_icon_portal.png')}}">
    <!-- AOS Animation CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css"
        integrity="sha512-1cK78a1o+ht2JcaW6g8OXYwqpev9+6GqOkz9xmBN9iUUhIndKtxwILGWYOSibOKjLsEdjyjZvYDq/cZwNeak0w=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>

<style>
      #login_page{
        background-color: #F1FCFF;
      }
      label.error {
        color: red;
      }

    </style>

<body>

    <!-- Navigation Bar -->
    <nav id="navbar" class="navbar">
        <div class="logo-container">
            <a href="{{route('main')}}">
                <img src="{{asset('images/gems-institue.png')}}" alt="nav_logo" class="nav_logo">
            </a>
        </div>
        <!-- <div class="login-btn-container">
           <a href="{{route('web.login')}}" class="nav-login-btn">
               <div class="text-container">Login Now</div>
           </a>
        </div> -->
    </nav>

    

    <main>

        <section class="hero-section">
            
            <div class="row" style="color:white;">

                @if (session('logout'))
                <div class="alert alert-success" role="alert">

                    <button class="close" data-dismiss="alert"></button>

                    {{ session('logout') }}

                </div>

                @endif

                @if(session()->has('error'))

                <div class="alert alert-danger">

                    <button class="close" data-dismiss="alert"></button>

                    {{ session()->get('error') }}

                </div>

                @endif

                @if (session('success'))
                <div class="alert alert-success" role="alert">
                    <button class="close" data-dismiss="alert"></button>
                    {{ session('success') }}
                </div>
                @endif

                <form id="form-login" class="form1" action="{{ route('web.sign-up-user') }}" method="POST">
                @csrf

                    <h2>Register Now</h2>

                    <div class="col-md-4">
                        <lable>Full Name</lable>
                        <input type="text" class="form-control" name="name" placeholder="Enter name of student">
                    </div>

                    @error('name')
                    <label class="error">
                        <strong>{{ $message }}</strong>
                    </label>
                    @enderror

                    <div class="col-md-4">
                        <lable>Email</lable>
                        <input type="text" class="form-control" name="email" placeholder="Enter email" >
                    </div>

                    @error('email')
                    <label class="error">
                        <strong>{{ $message }}</strong>
                    </label>
                    @enderror

                    <div class="col-md-4">
                        <lable>Password</lable>
                        <input type="password" class="form-control" name="password" placeholder="Enter Password" >
                    </div>

                    @error('password')
                    <label class="error">
                        <strong>{{ $message }}</strong>
                    </label>
                    @enderror

                    <div class="col-md-4">
                        <lable>College Name</lable>
                        <input type="text" class="form-control" name="college_name" placeholder="Enter College Name" >
                    </div>

                    @error('college_name')
                    <label class="error">
                        <strong>{{ $message }}</strong>
                    </label>
                    @enderror

                    <div class="col-md-4">
                        <label>Course </label>
                        <select name="course_id" class="form-control form-select select2" data-bs-placeholder="Select Course">
                            <option value="">Select Course </option>
                            @foreach($getCourse as $course)
                                <option value="{{$course->id}}">{{$course['name']}}</option>
                            @endforeach
                        </select>
                    </div>
                    @error('course_id')
                    <label class="error">
                        <strong>{{ $message }}</strong>
                    </label>
                    @enderror

                    <div class="col-md-4">
                        <lable>Referral Code</lable>
                        <input type="text" class="form-control" name="refferal_from" value="{{$code}}" placeholder="Referral Code" readonly>
                    </div>

                    @error('refferal_from')
                    <label class="error">
                        <strong>{{ $message }}</strong>
                    </label>
                    @enderror

                    <div class="col-md-4">
                        <button class="login__btn submit-btn">Submit</button>
                    </div>

                    <div class="col-md-4">
                        <a href="{{route('web.login')}}">Already have an account? Login</a>
                    </div>

                </form>
            </div>
        </section>

    </main>

    <footer class="footer">
        <div class="footer-blur-1" data-aos="fade-up"></div>
        <img src="{{asset('images/footer-coin-img.png')}}" alt="footer-coin-img" class="footer-coin-img">
        <div class="footer-blur-2" data-aos="fade-up"></div>
       
        <a href="{{route('main')}}" class="footer-company-logo">
            <img src="{{asset('images/nav_logo.png')}}" alt="nav_logo" class="footer-logo">
        </a>

        <div class="copy-right-text">
            Copyright © 2024 Student Portal. All Rights Reserved. <br>
            <a href="#">Terms of use</a> <span>|</span> <a href="#">Cookies Policy</a>
        </div>
    </footer>

    <!-- Bootstrap JavaScript CDN -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
        integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r"
        crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.min.js"
        integrity="sha384-Rx+T1VzGupg4BHQYs2gCW9It+akI2MM/mndMCy36UVfodzcJcF0GGLxZIzObiEfa"
        crossorigin="anonymous"></script>

    <!-- AOS Animation JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js"
        integrity="sha512-A7AYk1fGKX6S2SsHywmPkrnzTZHrgiVT7GcQkLGDe2ev0aWb8zejytzS8wjo7PGEXKqJOrjQ4oORtnimIRZBtw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <!-- Custom JavaScript -->
    <script src="{{asset('js/javascript.js')}}"></script>
</body>

</html>