
@extends('web.layout.main')
@section('content')

    <section class="card__main__section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-11">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="card__info__balance" style="background:url({{asset('images/wallet__image.png')}});">
        
                                    <h4>Total Earning </h4>
                                     <h2>₹{{$wallet_balance['wallet_balance']}} </h2>
                                    <div class="card__list__info">
                                        <div class="card__items">
                                            <p>{{$wallet_balance['wallet_update_date']}}</p>
                                        </div>
                                        <div class="card__list__btn">
                                            <img src="{{asset('images/doller-image.png')}}">
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>    
        </div>
     
    </section>
    
    
    <section class="faq_main">
        <div class="container">
            <div class="faq_wrapper">
                <h2 class="comman_small_head text-center">Team List</h2>
                <div class="data__filter__row">
                    <h2>Transaction History</h2>
                    <form method="GET" action="{{ route('web.team') }}">
                        <div class="data__filter">
                            <div class="datafilter">
                                <label>Level</label>
                                <select class="form-control" name="level">
                                    <option value="">Select Level</option>
                                    <option value="1" {{ request('level') == 1 ? 'selected' : '' }}>Level 1</option>
                                    <option value="2" {{ request('level') == 2 ? 'selected' : '' }}>Level 2</option>
                                    <option value="3" {{ request('level') == 3 ? 'selected' : '' }}>Level 3</option>
                                    <option value="4" {{ request('level') == 4 ? 'selected' : '' }}>Level 4</option>
                                    <option value="5" {{ request('level') == 5 ? 'selected' : '' }}>Level 5</option>
                                </select>
                            </div>
                            <div>
                                <button type="submit">Apply</button>
                                <a href="{{route('web.team')}}">Cancel</a>
                            </div>
                            {{-- <div class="datafilter">
                                <input type="date" name="date" class="form-control" placeholder="Select Date Range">
                            </div> --}}
                        </div>
                    </form>
                    
                    
                </div>
                
                <table class="table card-table table-vcenter text-nowrap align-items-center data-table" style="color:white;">
                    <thead class="thead-light">
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Level</th>
                            <th>Status</th>
                        </tr>
                    </thead>
					
                    <tbody>

                        @foreach($referredUsers as $data)
                           
                            <tr>
                                <td>{{ $data['name'] }}</td>
                                <td>{{ $data['email']}}</td>
                                <td>{{ $data['level'] }}</td>
                                <td>{{ ucfirst($data['status'])}}</td>
                            </tr>
                        @endforeach
                        
                    </tbody>
				</table>

            </div>
        </div>
    </section>

@endsection

<script src="{{asset('js/jquery.min.js')}}"></script>

<script type="text/javascript">
    $(function () {
        var table = $('.data-table').DataTable();
    });
</script>
