<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthenticationController;
use App\Http\Controllers\API\AdController;
use App\Http\Controllers\API\HomebannerController;
use App\Http\Controllers\API\CmsPageController;
use App\Http\Controllers\API\CoinPaymentController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });
Route::post('sign-up', [AuthenticationController::class, 'signUp']);
Route::post('login', [AuthenticationController::class, 'login'])->name('login');
Route::post('forgot-password', [AuthenticationController::class, 'forgot_password']);
Route::post('email-verify', [AuthenticationController::class, 'email_verify'])->name('email_verify');
Route::post('reset-password', [AuthenticationController::class, 'reset_password'])->name('reset_password');
Route::post('signup-code-verify', [AuthenticationController::class, 'signUp_code_verify']);
Route::post('resend-code', [AuthenticationController::class, 'resend_code']);
Route::get('cms-pages', [CmsPageController::class, 'getPages']);
Route::get('setting', [HomebannerController::class, 'getSettingData']);

Route::group(['middleware' => ['auth:user-api']], function() {  
    Route::get('get-profile',[AuthenticationController::class, 'getProfile']);  
    Route::post('update-profile', [AuthenticationController::class, 'updateProfile']);
    Route::post('change-password', [AuthenticationController::class, 'change_password'])->name('change_password');
    Route::get('delete-account', [AuthenticationController::class, 'deleteAccount']);
    Route::post('update-fcm',[AuthenticationController::class, 'updateFcmToken']);
    Route::get('get-wallet', [AuthenticationController::class, 'getUserWallet']);
    Route::get('ads-list', [AdController::class, 'list'])->name('list');
    Route::get('homebanner-list', [HomebannerController::class, 'homebannerList']);
    Route::post('ad-watch', [AdController::class, 'videoWatch']);
    Route::get('wallet-history', [AdController::class, 'walletHistory']);
    Route::get('card-history', [AdController::class, 'cardHistory']);
    Route::get('plan-list', [AdController::class, 'planList']);
    Route::get('active-plan', [AdController::class, 'activePlan']);
    Route::get('video-earning', [AdController::class, 'videoEarning']);
    Route::get('payment', [CoinPaymentController::class, 'createPayment']);
    Route::post('plan-purchase', [CoinPaymentController::class, 'plan_purchase']);
    Route::get('referral-user-list', [AuthenticationController::class, 'referral_user_list']);
    Route::get('invoice-create', [CoinPaymentController::class, 'invoice_create']);
    Route::get('add-wallet-amount', [CoinPaymentController::class, 'add_wallet_amount']);
    Route::post('withdrawal-request', [CoinPaymentController::class, 'withdrawal_request']);
    Route::get('pool-list', [HomebannerController::class, 'pool_list']);
    Route::post('invest-pool', [HomebannerController::class, 'invest_pool']);
    Route::get('pool-history', [HomebannerController::class, 'pool_history']);
    
});

