<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\LoginController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\HomeBannerController;
use App\Http\Controllers\Admin\PlanController;
use App\Http\Controllers\Admin\AdsController;
use App\Http\Controllers\Admin\CreditHistoryController;
use App\Http\Controllers\Admin\WalletHistoryController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\PoolController;
use App\Http\Controllers\Admin\CourseController;
use App\Http\Controllers\Admin\LeadController;

use App\Http\Controllers\Web\UserLoginController;
use App\Http\Controllers\Web\UserDashboardController;

use App\Http\Controllers\CronJobController;
use App\Http\Controllers\Web\CommonController;
use App\Http\Controllers\Web\UserLeadController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('web.index');
})->name('main');

Route::get('/pool-invest-earning',  [CronJobController::class, 'pool_invest_earning']);
Route::get('/sign-up', [UserLoginController::class, 'signUp'])->name('web.sign-up');
Route::post('/sign-up-user', [UserLoginController::class, 'signUpUserSave'])->name('web.sign-up-user');
Route::get('/payment', [UserLoginController::class, 'payment'])->name('web.payment');
Route::get('/help', [CommonController::class, 'help'])->name('web.help');
Route::post('/forgot-password-mail', [CommonController::class, 'forgotPasswordMail'])->name('web.forgot-password-mail');


Route::group(['namespace'=>'User','prefix' => 'user'], function () {

    //admin route without auth
    Route::get('/',function(){
    //    return redirect()->route('web.home'); 
        return view('web.index');
    });

    Route::get('/login', function() {
    //   dd( Auth::user()->is_admin);
        if(Auth::check() && Auth::user()->user_type != '1') 
        {
            return redirect()->route('web.dashboard');
        }
        return view('web.login');
    })->name('web.login');
    Route::post('/login',  [UserLoginController::class, 'validateLogin'])->name('web.login.validate');

}); 

Route::get('/user-logout',  [UserLoginController::class, 'logout'])->name('web.logout');


Route::post('/withdraw-request', [UserDashboardController::class, 'withdraw_request'])->name('web.add-withdraw-request');
Route::post('/invest-pool', [UserDashboardController::class, 'invest_pool'])->name('invest-pool');
// Route::post('/save-video-duration', [UserDashboardController::class, 'saveVideoDuration'])->name('video.duration.store');
Route::post('/store-token', [UserDashboardController::class, 'storeToken'])->name('store.token');

Route::group(['middleware' => 'auth'], function () {
    Route::group(['namespace'=>'User','prefix' => 'student'], function () {
        Route::get('/dashboard', [UserDashboardController::class, 'home'])->middleware('webuser')->name('web.dashboard');
        Route::get('/plan-detail/{id}', [UserDashboardController::class, 'plan_detail'])->name('web.plan_detail');
        Route::get('/withdraw', [UserDashboardController::class, 'exchange'])->name('web.exchange');
        Route::get('/earnings', [UserDashboardController::class, 'earnings'])->name('web.earnings');
        Route::get('/pool-list', [UserDashboardController::class, 'pool_list'])->name('web.pool-list');
        Route::get('/setting', [UserDashboardController::class, 'setting'])->name('web.setting');
        Route::get('/delete-account', [UserDashboardController::class, 'deleteAccount'])->name('web.deleteAccount');
        Route::get('/change-password', [UserDashboardController::class, 'changePassword'])->name('web.changePassword');
        Route::post('/change_password', [UserDashboardController::class, 'changePasswordSave'])->name('web.change-password.save');
        Route::get('/update-profile', [UserDashboardController::class, 'updateProfile'])->name('web.update-profile');
        Route::post('/update-profile-save', [UserDashboardController::class, 'updateProfileSave'])->name('web.update-profile.save');
        Route::get('/earnings/pool-history', [UserDashboardController::class, 'pool_history'])->name('web.pool_history');
        Route::get('/earnings/comission', [UserDashboardController::class, 'referral_history'])->name('web.referral_history');
        Route::get('/plan-list', [UserDashboardController::class, 'all_plan'])->name('web.all_plan');
        Route::post('/plan-purchase', [UserDashboardController::class, 'plan_purchase'])->name('web.plan-purchase');
        Route::get('/team', [UserDashboardController::class, 'teamList'])->name('web.team');
        Route::get('/ad-list', [UserDashboardController::class, 'adList'])->name('web.ad-list');
        Route::get('/video/{id}', [UserDashboardController::class, 'showAdd'])->name('video.show');
        Route::post('/ad-watch', [UserDashboardController::class, 'adWatch'])->name('web.ad-watch');
        Route::get('/lead-management', [UserLeadController::class, 'lead_list'])->name('web.lead-list');
        Route::get('/edit/{id}', [UserLeadController::class, 'update'])->name('web.lead.edit');
        Route::post('/edit', [UserLeadController::class, 'update'])->name('web.lead.update');
        Route::get('/delete/{id}',[UserLeadController::class, 'delete'])->name('web.lead.deleteSingle');
        Route::get('/add',[UserLeadController::class, 'add'])->name('web.lead.add');
        Route::post('/add',[UserLeadController::class, 'add'])->name('web.lead.save');
        Route::get('/course', [CommonController::class, 'course_list'])->name('web.course-list');
    });
});

Route::group(['namespace'=>'Admin','prefix' => 'admin'], function () {
    //admin route without auth
    Route::get('/',function(){
        return redirect()->route('admin.login'); 
    });
    Route::get('/login', function() {
        if(Auth::check()) 
        {
            return redirect()->route('admin.home');
        }
        return view('admin.login');
    })->name('admin.login');
    
    Route::post('/login',  [LoginController::class, 'validateLogin'])->name('admin.login.validate');
});

Route::get('/logout',  [LoginController::class, 'logout'])->name('admin.logout');
Route::get('/admin/dashboard', [DashboardController::class, 'home'])->middleware('superadmin')->name('admin.home');


Route::group(['prefix'=>'admin/user'],function(){
    Route::get('/', [UserController::class, 'index'])->name('admin.user.list');
    Route::get('/add',[UserController::class, 'add'])->name('admin.user.add');
    Route::post('/add',[UserController::class, 'add'])->name('admin.user.save');
    Route::get('/edit/{id}', [UserController::class, 'update'])->name('admin.user.edit');
    Route::post('/edit', [UserController::class, 'update'])->name('admin.user.update');
    Route::get('/delete/{id}',[UserController::class, 'delete'])->name('admin.user.deleteSingle');
    Route::get('/view/{id}', [UserController::class, 'view'])->name('admin.user.view');
    Route::get('/wallet-history/{id}', [UserController::class, 'walletHistoryUser'])->name('admin.user.wallet-history');
    
    Route::get('/view-level-2/{id}', [UserController::class, 'viewLevel2'])->name('admin.user.viewLevel2');
    Route::get('/view-level-3/{id}', [UserController::class, 'viewLevel3'])->name('admin.user.viewLevel3');
    Route::get('/activity-log', [UserController::class, 'activityLog'])->name('admin.activity-log.list');
});

Route::group(['prefix'=>'admin/course'],function(){
    Route::get('/', [CourseController::class, 'index'])->name('admin.course.list');
    Route::get('/add',[CourseController::class, 'add'])->name('admin.course.add');
    Route::post('/add',[CourseController::class, 'add'])->name('admin.course.save');
    Route::get('/edit/{id}', [CourseController::class, 'update'])->name('admin.course.edit');
    Route::post('/edit', [CourseController::class, 'update'])->name('admin.course.update');
    Route::get('/delete/{id}',[CourseController::class, 'delete'])->name('admin.course.deleteSingle');
});

Route::group(['prefix'=>'admin/lead'],function(){
    Route::get('/', [LeadController::class, 'index'])->name('admin.lead.list');
    Route::get('/add',[LeadController::class, 'add'])->name('admin.lead.add');
    Route::post('/add',[LeadController::class, 'add'])->name('admin.lead.save');
    Route::get('/edit/{id}', [LeadController::class, 'update'])->name('admin.lead.edit');
    Route::post('/edit', [LeadController::class, 'update'])->name('admin.lead.update');
    Route::get('/delete/{id}',[LeadController::class, 'delete'])->name('admin.lead.deleteSingle');
});

Route::group(['prefix'=>'admin/generate-certificate'],function(){
    Route::get('/', [UserController::class, 'generate_certificate_list'])->name('admin.generate-certificate.list');
    Route::get('/generate-pdf/{id}', [UserController::class, 'generatePdf'])->name('admin.generate-pdf');
});

Route::group(['prefix'=>'admin/home-banner'],function(){
    Route::get('/', [HomeBannerController::class, 'index'])->name('admin.home-banner.list');
    Route::get('/add',[HomeBannerController::class, 'add'])->name('admin.home-banner.add');
    Route::post('/add',[HomeBannerController::class, 'add'])->name('admin.home-banner.save');
    Route::get('/edit/{id}', [HomeBannerController::class, 'update'])->name('admin.home-banner.edit');
    Route::post('/edit', [HomeBannerController::class, 'update'])->name('admin.home-banner.update');
    Route::get('/delete/{id}',[HomeBannerController::class, 'delete'])->name('admin.home-banner.deleteSingle');
});

Route::group(['prefix'=>'admin/plan'],function(){
    Route::get('/', [PlanController::class, 'index'])->name('admin.plan.list');
    Route::get('/add',[PlanController::class, 'add'])->name('admin.plan.add');
    Route::post('/add',[PlanController::class, 'add'])->name('admin.plan.save');
    Route::get('/edit/{id}', [PlanController::class, 'update'])->name('admin.plan.edit');
    Route::post('/edit', [PlanController::class, 'update'])->name('admin.plan.update');
    Route::get('/delete/{id}',[PlanController::class, 'delete'])->name('admin.plan.deleteSingle');
});

Route::group(['prefix'=>'admin/pool'],function(){
    Route::get('/', [PoolController::class, 'index'])->name('admin.pool.list');
    Route::get('/add',[PoolController::class, 'add'])->name('admin.pool.add');
    Route::post('/add',[PoolController::class, 'add'])->name('admin.pool.save');
    Route::get('/edit/{id}', [PoolController::class, 'update'])->name('admin.pool.edit');
    Route::post('/edit', [PoolController::class, 'update'])->name('admin.pool.update');
    Route::get('/delete/{id}',[PoolController::class, 'delete'])->name('admin.pool.deleteSingle');
});

Route::group(['prefix'=>'admin/ads'],function(){
    Route::get('/', [AdsController::class, 'index'])->name('admin.ads.list');
    Route::get('/add',[AdsController::class, 'add'])->name('admin.ads.add');
    Route::post('/add',[AdsController::class, 'add'])->name('admin.ads.save');
    Route::get('/edit/{id}', [AdsController::class, 'update'])->name('admin.ads.edit');
    Route::post('/edit', [AdsController::class, 'update'])->name('admin.ads.update');
    Route::get('/delete/{id}',[AdsController::class, 'delete'])->name('admin.ads.deleteSingle');
});

Route::group(['prefix'=>'admin/credit-history'],function(){
    Route::get('/', [CreditHistoryController::class, 'index'])->name('admin.credit-history.list');
});

Route::group(['prefix'=>'admin/wallet-history'],function(){
    Route::get('/', [WalletHistoryController::class, 'index'])->name('admin.wallet-history.list');
});
Route::post('changeWithdrawalStatusByAdmin', [WalletHistoryController::class, 'changeWithdrawalStatusByAdmin'])->name('changeWithdrawalStatusByAdmin');

Route::group(['prefix'=>'admin/setting'],function(){
    Route::get('/', [SettingController::class, 'index'])->name('admin.setting');
    Route::post('/setting/save',[SettingController::class, 'saveBasic'])->name('admin.setting.save');
});

Route::group(['prefix'=>'admin/deposit-history'],function(){
    Route::get('/', [WalletHistoryController::class, 'deposit_history'])->name('admin.deposit-history.list');
});

Route::group(['prefix'=>'admin/withdrawal-history'],function(){
    Route::get('/', [WalletHistoryController::class, 'withdrawal_history'])->name('admin.withdrawal-history.list');
    Route::post('/change-withdrawal-request-status',[WalletHistoryController::class, 'change_withdrawal_request_status'])->name('admin.change_withdrawal_request_status');
});

Route::get('/admin/update-profile', [SettingController::class, 'updateProfile'])->name('admin.profile.update');
Route::post('/admin/edit-profile', [SettingController::class, 'editProfile'])->name('admin.profile.edit');