<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Portal</title>

    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/style_web.css')); ?>">

    <!-- Bootstrap CSS CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9" crossorigin="anonymous">

    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"
        integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="icon" href="<?php echo e(asset('images/fav_icon_portal.png')); ?>">
    <!-- AOS Animation CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css"
        integrity="sha512-1cK78a1o+ht2JcaW6g8OXYwqpev9+6GqOkz9xmBN9iUUhIndKtxwILGWYOSibOKjLsEdjyjZvYDq/cZwNeak0w=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>

<style>
      #login_page{
        background-color: #F1FCFF;
      }
      label.error {
        color: red;
      }

    </style>

<body>

    <!-- Navigation Bar -->
    <nav id="navbar" class="navbar">
        <div class="logo-container">
            <a href="<?php echo e(route('main')); ?>">
                <img src="<?php echo e(asset('images/gems-institue.png')); ?>" alt="nav_logo" class="nav_logo">
            </a>
        </div>
        <!-- <div class="login-btn-container">
           <a href="<?php echo e(route('web.login')); ?>" class="nav-login-btn">
               <div class="text-container">Login Now</div>
           </a>
        </div> -->
    </nav>

    

    <main>

        <section class="hero-section">
            
            <div class="row" style="color:white;">

                <?php if(session('logout')): ?>
                <div class="alert alert-success" role="alert">

                    <button class="close" data-dismiss="alert"></button>

                    <?php echo e(session('logout')); ?>


                </div>

                <?php endif; ?>

                <?php if(session()->has('error')): ?>

                <div class="alert alert-danger">

                    <button class="close" data-dismiss="alert"></button>

                    <?php echo e(session()->get('error')); ?>


                </div>

                <?php endif; ?>

                <?php if(session('success')): ?>
                <div class="alert alert-success" role="alert">
                    <button class="close" data-dismiss="alert"></button>
                    <?php echo e(session('success')); ?>

                </div>
                <?php endif; ?>

                <form id="form-login" class="form1" action="<?php echo e(route('web.login.validate')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                    <h2>Login Now</h2>

                    <div class="col-md-4">
                        <lable>Email</lable>
                        <input type="text" id="email" class="form-control" name="email" placeholder="Enter email address">
                    </div>

                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <label class="error">
                        <strong><?php echo e($message); ?></strong>
                    </label>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    <div class="col-md-4">
                        <lable>Password</lable>
                        <input type="password" class="form-control" name="password" placeholder="Enter Password">
                    </div>

                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <label class="error">
                        <strong><?php echo e($message); ?></strong>
                    </label>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    <div class="col-md-4">
                        <button class="login__btn submit-btn">Login Now</button>
                    </div>

                    <!-- <div class="text-center link__signup">
                        <a href="#;" class="forgot__password">Forgot Password</a>
                    </div> -->

                    <div class="col-md-4">
                        <a href="<?php echo e(route('web.sign-up')); ?>">Don’t have any account? Sign Up</a>
                    </div>

                </form>
            </div>
        </section>



    </main>


    <footer class="footer">
        <div class="footer-blur-1" data-aos="fade-up"></div>
        <img src="<?php echo e(asset('images/footer-coin-img.png')); ?>" alt="footer-coin-img" class="footer-coin-img">
        <div class="footer-blur-2" data-aos="fade-up"></div>
      

        <a href="<?php echo e(route('main')); ?>" class="footer-company-logo">
            <img src="<?php echo e(asset('images/nav_logo.png')); ?>" alt="nav_logo" class="footer-logo">
        </a>

        <div class="copy-right-text">
            Copyright © 2024 Infinite. All Rights Reserved. <br>
            <a href="#">Terms of use</a> <span>|</span> <a href="#">Cookies Policy</a> <span>|</span> <a href="<?php echo e(route('web.help')); ?>">Help Center</a>
        </div>
    </footer>

    <!-- Bootstrap JavaScript CDN -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
        integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r"
        crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.min.js"
        integrity="sha384-Rx+T1VzGupg4BHQYs2gCW9It+akI2MM/mndMCy36UVfodzcJcF0GGLxZIzObiEfa"
        crossorigin="anonymous"></script>

    <!-- AOS Animation JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js"
        integrity="sha512-A7AYk1fGKX6S2SsHywmPkrnzTZHrgiVT7GcQkLGDe2ev0aWb8zejytzS8wjo7PGEXKqJOrjQ4oORtnimIRZBtw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <!-- Custom JavaScript -->
    <script src="<?php echo e(asset('js/javascript.js')); ?>"></script>
</body>

<script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/css/toastr.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/js/toastr.js"></script>

<script>
        $(document).ready(function() {
            $('.forgot__password').click(function() {
                var email = $("#email").val();
                if (email == '') {
                    toastr.error('Please Enter Email!');
                }else{
                    $.ajax({
                    url: "<?php echo e(route('web.forgot-password-mail')); ?>",
                    type: 'post',
                    dataType: "html",
                    data: {
                        email: email,
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function(response) {
                        if (response == 'true') {
                            toastr.success('We have sent mail to registered email id!');
                        }else {
                            toastr.error('Something went wrong!');
                        }
                    },
                    error: function(xhr, status, error) {
                        toastr.error('Error occurred while forgot password');
                    }
            });
                }
            });
        });
    
    </script>

</html><?php /**PATH D:\laragon\www\portal\resources\views\web\login.blade.php ENDPATH**/ ?>