<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ceritificates</title>
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <!-- <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet"> -->

    <style>
        @font-face {
            font-family: "PlayfairDisplay-Bold";
            src: url("../fonts/PlayfairDisplay-Bold.ttf");
        }

        @font-face {
            font-family: "PlayfairDisplay-Regular";
            src: url("../fonts/PlayfairDisplay-Regular.ttf");
        }

        @font-face {
            font-family: "Poppins-Regular";
            src: url("../fonts/Poppins-Regular.ttf");
        }

        @font-face {
            font-family: "times";
            src: url("../fonts/times.ttf");
        }

        @font-face {
            font-family: "Poppins-SemiBold";
            src: url("../fonts/Poppins-SemiBold.ttf");
        }

        @font-face {
            font-family: "Poppins-Medium";
            src: url("../fonts/Poppins-Medium.ttf");
        }

        .certificates {
            background: url("images/certificate-bg.png");
            background-repeat: no-repeat;
            background-size:cover;
            width: 100%;

        }

        .certificates .container {
            width: 100%;
            padding: 100px;
        }

        .logo {
            justify-content: end;
            display: flex;
            margin: 20px 35px 0px 0px;
        }

        .certificates-title h2 {
            font-size: 45px;
            letter-spacing: 2.7px;
            color: #15344D;
            font-family: "PlayfairDisplay-Bold";
            margin-bottom: 0px;
        }

        .certificates-title p {
            font-size: 28px;
            letter-spacing: 1.68px;
            color: #15344D;
            margin-bottom: 30px;
            margin-top: 0px;
            font-family: "PlayfairDisplay-Regular";
            text-shadow:
                0px 0px 0 #15344D,
                0px 0px 0 #15344D,
                0px 0px 0 #15344D,
                0px 0px 0 #15344D;
        }

        .certificates-details .presented {
            font-size: 12px;
            letter-spacing: 0.82px;
            color: #15344D;
            margin-bottom: 30px;
            text-align: center;
            font-family: "Poppins-Regular";
        }

        .certificates-details .presented-name {
            font-size: 37px;
            letter-spacing: 0px;
            color: #15344D;
            text-align: center;
            background: url("images/border.png");
            background-repeat: no-repeat;
            background-position-y: bottom;
            padding-bottom: 10px;
            background-position-x: center;
            margin-bottom: 20px;
            font-family: "times";
            font-weight: normal;
        }

        .logo-right {
            margin-top: 20px;
        }

        .certificates-details {
            margin-top: -80px;
        }

        .trening-period {
            text-align: center;
            font-size: 14px;
            letter-spacing: 0px;
            color: #193A50;
            font-weight: 600;
            padding: 0px 80px;
            margin-bottom: 60px;
            line-height: 25px;
            font-family: "Poppins-SemiBold";
        }

        .certificates-number .certificate-no {
            font-size: 20px;
            letter-spacing: 0px;
            color: #15344D;
            font-weight: 500;
            text-align: center;
            background: url("images/border.png");
            background-repeat: no-repeat;
            background-position-y: bottom;
            padding-bottom: 5px;
            background-position-x: center;
            margin-bottom: 5px;
            font-family: "Poppins-Medium";
            height: 30px;
        }

        .certificates-number .name {
            text-transform: uppercase;
            text-align: center;
            font-size: 11px;
            letter-spacing: 1.1px;
            color: #15344D;
            font-family: "Open Sans", sans-serif;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            margin-top: calc(-1 * var(--bs-gutter-y));
            margin-right: calc(-.5 * var(--bs-gutter-x));
            margin-left: calc(-.5 * var(--bs-gutter-x));
            height: 100%;
        }

        .row>* {
            flex-shrink: 0;
            width: 100%;
            max-width: 100%;
            padding-right: calc(var(--bs-gutter-x) * .5);
            padding-left: calc(var(--bs-gutter-x) * .5);
            margin-top: var(--bs-gutter-y);
        }

        .col-lg-8 {
            flex: 0 0 auto;
            width: 66.66666667% !important;
        }

        .col-lg-4 {
            flex: 0 0 auto;
            width: 33.33333333% !important;
        }

        .col-lg-12 {
            flex: 0 0 auto;
            width: 100%
        }

        .d-flex {
            display: flex !important
        }

        .justify-content-end {
            justify-content: flex-end !important
        }

        .mx-auto {
            margin-right: auto !important;
            margin-left: auto !important
        }

        .justify-content-center {
            justify-content: center !important
        }

        .text-center {
            text-align: center !important
        }

        .col-lg-3 {
            flex: 0 0 auto;
            width: 25%;
            padding: 0px 10px;
        }
    </style>
</head>

<body>
    <section class="certificates">
        <div class="container">
            <div class="row">
                <div class="col-lg-7">
                    <div class="logo">
                        <img src="<?php echo e(asset('images/gems institue.png')); ?>">
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="logo-right">
                        <img src="<?php echo e(asset('images/Group 47.png')); ?>">
                    </div>
                </div>
                <div class="col-lg-12 mx-auto d-flex justify-content-center">
                    <div class="certificates-details">
                        <div class="certificates-title text-center">
                            <h2>CERTIFICATE</h2>
                            <p>OF INTERNSHIP</p>
                        </div>
                        <div class="presented">THIS CERTIFICATE IS PROUDLY PRESENTED TO</div>
                        <div class="presented-name"><?php echo e($data['name']); ?></div>
                        <div class="trening-period">Has successfully completed Internship on <?php echo e($course_name['name']); ?> at <br>Gems Institute of Technology for the period of one month from <br>
                            <?php echo e($data['start_date']); ?> to <?php echo e($data['end_date']); ?>.</div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="certificates-number">
                        <div class="certificate-no">GIT-0<?php echo e($data['id']); ?></div>
                        <div class="name">certificate no.</div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="certificates-number">
                        <div class="certificate-no"><img src="<?php echo e(asset('images/signature.png')); ?>"></div>
                        <div class="name">OPERATIONAL HEAD</div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="certificates-number">
                        <div class="certificate-no"><?php echo e($data['end_date']); ?></div>
                        <div class="name">ISSUE DATE</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script> -->
</body>

</html><?php /**PATH D:\laragon\www\portal\resources\views/admin/generate-certificate/generate-pdf.blade.php ENDPATH**/ ?>