

<?php $__env->startSection('content'); ?>
		<!-- GLOBAL-LOADER -->
		<div id="global-loader">
			<img src="../assets/images/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /GLOBAL-LOADER -->

		<!-- PAGE -->
			
                <!--app-content open-->
				<div class="app-content main-content">
					<div class="side-app">

						<div class="main-container">

						<!-- PAGE-HEADER -->
						<div class="page-header">
							<div>
								<h1 class="page-title">Update Student</h1>
								<ol class="breadcrumb">
									<li class="breadcrumb-item"><a href="#">Main</a></li>
									<li class="breadcrumb-item active" aria-current="page">Update Student</li>
								</ol>
							</div>
						</div>
						<!-- PAGE-HEADER END -->

						<!-- ROW-1 OPEN -->
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="card-title">Update Student</div>
                                    </div>
                                    <div class="card-body">
                                        <form autocomplete="off" role="form" id="saveForm" action="<?php echo e(route('admin.user.update')); ?>" method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>

                                            <div class="row mb-4">
                                                <input type="hidden" value="<?php echo e($user->id); ?>" name="id">
                                                <label class="col-md-3 form-label">User Name :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="name" class="form-control" value='<?php echo e(old(' name') ?? $user->name); ?>' placeholder="User Name" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Email :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="email" class="form-control" value='<?php echo e(old(' email') ?? $user->email); ?>' readonly>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Mobile :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="mobile" class="form-control" value='<?php echo e(old('mobile') ?? $user->mobile); ?>' placeholder="Mobile" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">College Name :</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="college_name" class="form-control" value='<?php echo e(old('college_name') ?? $user->college_name); ?>' placeholder="College Name" required>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Course :</label>
                                                <?php $course_name = App\Models\Course::where('id',$user->course_id)->first();?>
                                                <div class="col-md-9">
                                                    <input type="text" name="course_id" class="form-control" value='<?php echo e(old('course_id') ?? $course_name['name']); ?>' readonly>
                                                </div>
                                            </div>


                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Image :</label>
                                                <div class="col-md-9 file-upload">
                                                        <div class="col-md-9 file-select">
                                                            <input type="file" name="image" id="image" accept=".png, .jpg, .jpeg">
                                                            <div class="profile__image">
                                                                <img width="100px" height="100px" accept=".png, .jpg, .jpeg" name="old_image" class="upload-img" src="<?php echo e($user->photo); ?>" />
                                                            </div>
                                                        </div>
                                                </div>
                                            </div>
                                        
                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Status :</label>
                                                <div class="col-md-9">
                                                    <select name="status" class="form-control form-select select2" data-bs-placeholder="Select Status">
                                                        <option value="active" <?php if($user->status == 'active'): ?> selected="selected" <?php endif; ?>>Active</option>
                                                        <option value="in-active" <?php if($user->status == 'in-active'): ?> selected="selected" <?php endif; ?>>In-Active</option>
                                                </select>
                                                </div>
                                            </div>

                                            <div class="row mb-4">
                                                <label class="col-md-3 form-label">Payment Status :</label>
                                                <div class="col-md-9">
                                                    <select name="status" class="form-control form-select select2" data-bs-placeholder="Select Payment Status">
                                                        <option value="pending" <?php if($user->payment_status == 'pending'): ?> selected="selected" <?php endif; ?>>Pending</option>
                                                        <option value="completed" <?php if($user->payment_status == 'completed'): ?> selected="selected" <?php endif; ?>>Completed</option>
                                                </select>
                                                </div>
                                            </div>
                                    </div>

                                    <div class="card-footer">
                                        <!--Row-->
                                        <div class="row">
                                            <div class="col-md-3"></div>
                                            <div class="col-md-9">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                <a class="btn btn-default float-end" href='<?php echo e(route('admin.user.list')); ?>'>
                                                    Close
                                                </a>
                                               
                                            </div>
                                        </div>
                                        <!--End Row-->
                                    </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- /ROW-1 CLOSED -->

					</div>
					<!-- CONTAINER CLOSED -->
				</div>
			</div>	
		<!-- </div> -->
<?php $__env->stopSection(); ?>
		
<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\portal\resources\views\admin\user\update.blade.php ENDPATH**/ ?>