

<?php $__env->startSection('content'); ?>
<style>
    #closeButton {
        display: none; /* Initially hide the close button */
    }
    #countdown {
        display: none; /* Initially hide the countdown */
        position: absolute;
        top: 10px;
        right: 10px;
        background-color: rgba(0, 0, 0, 0.5);
        color: white;
        padding: 5px;
        border-radius: 5px;
    }
</style>

<div class="container">
    <div class="row">
        <div class="col-md-10 position-relative">
            <h2><?php echo e($video->title); ?></h2>
            <div class="video-player">
                

                <input type="hidden" id="ad_id" name="ad_id" value="<?php echo e($video->id); ?>">
                <video id="videoFrame" width="100%" height="315" controls autoplay>
                    <source src="<?php echo e($video->video); ?>">
                    Your browser does not support the video tag.
                </video>
            </div>
            <p><?php echo e($video->coin); ?> Coin</p>
            
            <div id="countdown"><?php echo e($skipTime); ?></div>
        </div>
        <div class="col-md-2">
            
            <button id="closeButton" class="btn btn-secondary">Add Reward</button>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var video = document.getElementById('videoFrame');
        var closeButton = document.getElementById('closeButton');
        var countdown = document.getElementById('countdown');
        var countdownTime = parseInt(countdown.innerText.replace(/\D/g, '')); // Extract numeric value from countdown text
        var countdownInterval;

        video.addEventListener('play', function() {
            startCountdown();
        });

        video.addEventListener('pause', function() {
            stopCountdown();
        });

        video.addEventListener('ended', function() {
            stopCountdown();
        });

        function startCountdown() {
            countdown.style.display = 'block';
            closeButton.style.display = 'none';

            countdownInterval = setInterval(function() {
                countdownTime -= 1;
                // countdown.innerText = 'Skip Ad in: ' + countdownTime;
                countdown.innerText = countdownTime;

                if (countdownTime <= 0) {
                    clearInterval(countdownInterval);
                    countdown.style.display = 'none';
                    closeButton.style.display = 'block';
                }
            }, 1000);
        }

        function stopCountdown() {
            clearInterval(countdownInterval);
            countdown.style.display = 'none';
        }

        function closeVideo() {
            video.pause();
            closeButton.style.display = 'none';
            countdown.style.display = 'none';
        }
    });
</script>
<?php $__env->stopSection(); ?>

<script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/css/toastr.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/js/toastr.js"></script>

<script>
    $(document).ready(function(){

        $('#closeButton').click(function(){
            var video_id = $("#ad_id").val();
            var redirect_url = "<?= route('web.ad-list') ?>";
            
            // AJAX request
            $.ajax({
                    url:  "<?= route('web.ad-watch') ?>",
                    type: 'post',
                    dataType: "html",
                    data: { 
                        video_id: video_id,
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function(response){ 
                        if(response == 'true'){
                            toastr.success('Claim successfully!');
                            window.location.href = redirect_url;
                            // location.reload(true);
                        }else{
                            toastr.error('Something went wrong!');
                        }
                      
                    }
            });
        });

    });
</script>
<?php echo $__env->make('web.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\portal\resources\views\web\video-show.blade.php ENDPATH**/ ?>