<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Infinite</title>

    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/style_web.css')); ?>">

    <!-- Bootstrap CSS CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9" crossorigin="anonymous">

    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"
        integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <link rel="icon" href="<?php echo e(asset('images/nav_logo.png')); ?>">

    <!--  -->
    <!-- AOS Animation CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css"
        integrity="sha512-1cK78a1o+ht2JcaW6g8OXYwqpev9+6GqOkz9xmBN9iUUhIndKtxwILGWYOSibOKjLsEdjyjZvYDq/cZwNeak0w=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>

<body>

    <!-- Navigation Bar -->
        
    <nav id="navbar" class="navbar">
        <div class="logo-container">
            <a href="<?php echo e(route('main')); ?>">
                <img src="<?php echo e(asset('images/nav_logo.png')); ?>" alt="nav_logo" class="nav_logo">
            </a>
        </div>
        <div class="login-btn-container">
           <a href="<?php echo e(route('web.login')); ?>" class="nav-login-btn">
               <div class="text-container">Login Now</div>
           </a>
        </div>
    </nav>
    

    <main>

    

  

        <section class="hero-section">
            <img src="<?php echo e(asset('images/dollar-coin-1.png')); ?>" alt="dollar-coin-1" class="dollar-coin-1" data-aos="fade-up">
            <img src="<?php echo e(asset('images/dollar-coin-2.png')); ?>" alt="dollar-coin-1" class="dollar-coin-2" data-aos="fade-up">
            <div class="row">
                <div class="col-md-7 mt-5 mt-md-0 d-flex order-md-1 order-2">
                    <div class="hero-sec-text-container" data-aos="fade-up">
                        <div class="hero-sec-sub-text">TOP EARNING MONEY BY WATCHING VIDEOS ADS</div>
                        <h1 class="hero-sec-header">Earn coins by Watching Ads with us.</h1>
                        <div class="hero-sec-text">Infinite provides a shared revenue model for users,
                            self<span>-</span>publishing creators, and advertising distributors.</div>

                        
                        <img src="<?php echo e(asset('images/hero-sec-text-img.png')); ?>" alt="hero-sec-text-img"
                            class="hero-sec-text-img">
                    </div>
                </div>
                <div class="col-md-5 d-flex order-md-2 order-1">
                    <div class="hero-img-container" data-aos="fade-down">
                        <img src="<?php echo e(asset('images/hero-sec-img.png')); ?>" alt="hero-sec-img" class="hero-sec-img">
                    </div>
                </div>
            </div>

            <div class="google-play-container">
                
            </div>
        </section>


        <section class="intro-sec">

            <div class="intro-sec-blur-img"></div>
            <div class="row">
                <div class="col-md-6 d-flex" data-aos="fade-down">
                    <img src="<?php echo e(asset('images/intro-sec-img.png')); ?>" alt="intro-sec-img" class="intro-sec-img img-fluid">
                </div>

                <div class="col-md-6 mt-5 mt-md-0 d-flex align-items-center">
                    <div class="section-text-container" data-aos="fade-up">
                        <div class="section-name-text">INTRODUCTION</div>
                        <div class="section-heading">Infinite App</div>
                        <p class="section-para">Lorem Ipsum is simply dummy text of the printing and typesetting
                            industry. Lorem Ipsum has been the industry<span>'</span>s standard dummy text ever since
                            the 1500s, when an unknown printer took a galley of type and scrambled it to make a type
                            specimen book. It has survived not only five centuries, but also the leap into electronic
                            typesetting, remaining essentially unchanged. It was popularised in the 1960s with the
                            release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop
                            publishing software like Aldus PageMaker including versions.</p>

                        <!--<a href="#" class="sec-btn">-->
                        <!--    <div class="sec-btn-text">Join Now</div>-->
                        <!--</a>-->
                    </div>
                </div>
            </div>
        </section>

        <iframe src="https://www.instagram.com/reel/CmI9qu-ISqx/embed/" title="W3Schools Free Online Web Tutorials">
            </iframe>

        <section class="benifit-sec">
            <div class="row">

                <div class="col-md-6 d-flex align-items-center order-2 order-md-1 mt-5 mt-md-0">
                    <div class="section-text-container" data-aos="fade-up">
                        <div class="section-name-text">BENEFITS</div>
                        <div class="section-heading">Why to choose us?</div>
                        <p class="section-para">Lorem Ipsum is simply dummy text of the printing and typesetting
                            industry. Lorem Ipsum has been the industry<span>'</span>s standard dummy text ever since
                            the 1500s, when an unknown printer took a galley of type and scrambled it to make a type
                            specimen book. It has survived not only five centuries, but also the leap.</p>

                        <a href="#" class="get-started-btn">
                            <div class="get-started-text">GET STARTED</div>
                            
                        </a>

                        <div class="google-play-container">
                            
                        </div>
                    </div>
                </div>

                <div class="col-md-6 d-flex order-1 order-md-2">
                    <img src="<?php echo e(asset('images/benifit-sec-img.png')); ?>" alt="benifit-sec-img"
                        class="benifit-sec-img img-fluid" data-aos="fade-down">
                </div>


            </div>
        </section>


        <section class="features-sec">
            <div class="section-name-text text-center" data-aos="fade-up">LIST OF FEATURES</div>
            <div class="section-heading text-center" data-aos="fade-up">Industry Features</div>

            <div class="features-card-container">
                <div class="row">
                    <div class="col-md-6 d-flex" data-aos="fade-down">
                        <div class="features-card">
                            <div class="features-card-img-container">
                                <img src="<?php echo e(asset('images/features-card-img.png')); ?>" alt="features-card-img"
                                    class="features-card-img">
                            </div>
                            <div class="features-card-text">Lorem Ipsum is simply dummy text of the rhe printing and
                                typesetting industry</div>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex" data-aos="fade-down">
                        <div class="features-card">
                            <div class="features-card-img-container">
                                <img src="<?php echo e(asset('images/features-card-img.png')); ?>" alt="features-card-img"
                                    class="features-card-img">
                            </div>
                            <div class="features-card-text">Lorem Ipsum is simply dummy text of the rhe printing and
                                typesetting industry</div>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex" data-aos="fade-down">
                        <div class="features-card">
                            <div class="features-card-img-container">
                                <img src="<?php echo e(asset('images/features-card-img.png')); ?>" alt="features-card-img"
                                    class="features-card-img">
                            </div>
                            <div class="features-card-text">Lorem Ipsum is simply dummy text of the rhe printing and
                                typesetting industry</div>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex" data-aos="fade-down">
                        <div class="features-card">
                            <div class="features-card-img-container">
                                <img src="<?php echo e(asset('images/features-card-img.png')); ?>" alt="features-card-img"
                                    class="features-card-img">
                            </div>
                            <div class="features-card-text">Lorem Ipsum is simply dummy text of the rhe printing and
                                typesetting industry</div>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex" data-aos="fade-down">
                        <div class="features-card">
                            <div class="features-card-img-container">
                                <img src="<?php echo e(asset('images/features-card-img.png')); ?>" alt="features-card-img"
                                    class="features-card-img">
                            </div>
                            <div class="features-card-text">Lorem Ipsum is simply dummy text of the rhe printing and
                                typesetting industry</div>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex" data-aos="fade-down">
                        <div class="features-card">
                            <div class="features-card-img-container">
                                <img src="<?php echo e(asset('images/features-card-img.png')); ?>" alt="features-card-img"
                                    class="features-card-img">
                            </div>
                            <div class="features-card-text">Lorem Ipsum is simply dummy text of the rhe printing and
                                typesetting industry</div>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <section class="text-section">
            <p class="text-sec-para" data-aos="fade-up">" Lorem Ipsum is simply dummy text of the printing and
                typesetting industry. Lorem
                Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a
                galley of type and scrambled it to make a type specimen book. It has survived not only five centuries,
                but also the leap."</p>
        </section>

        <section class="faq-section">
            <img src="<?php echo e(asset('images/dollar-coin-2.png')); ?>" alt="dollar-coin-2" class="faq-dollar-coin-1"
                data-aos="fade-up">
            <div class="section-name-text text-center" data-aos="fade-up">FAQ</div>
            <div class="section-heading text-center" data-aos="fade-up">Frequently Asked Questions </div>

            <div class="accordion faq-container" id="accordionExample">
                <div class="accordion-item" data-aos="fade-down">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            Lorem Ipsum is simply dummy text of the printing
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has
                            been the industry's standard dummy text ever since the when an unknown printer.
                        </div>
                    </div>
                </div>
                <div class="accordion-item" data-aos="fade-down">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Lorem Ipsum is simply dummy text of the printing
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has
                            been the industry's standard dummy text ever since the when an unknown printer.
                        </div>
                    </div>
                </div>
                <div class="accordion-item" data-aos="fade-down">
                    <h2 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Lorem Ipsum is simply dummy text
                        </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has
                            been the industry's standard dummy text ever since the when an unknown printer.
                        </div>
                    </div>
                </div>
                <div class="accordion-item" data-aos="fade-down">
                    <h2 class="accordion-header" id="headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            Lorem Ipsum is simply dummy text of the printing dummy text
                        </button>
                    </h2>
                    <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has
                            been the industry's standard dummy text ever since the when an unknown printer.
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <section class="our-partner-sec">

            <img src="<?php echo e(asset('images/dollar-coin-3.png')); ?>" alt="dollar-coin-3" class="partner-dollar-coin"
                data-aos="fade-up">
            <div class="section-name-text text-center" data-aos="fade-up">PARTNERS</div>
            <div class="section-heading text-center" data-aos="fade-up">Our Partners</div>

            <div class="partner-blur-img" data-aos="fade-up"></div>
            <div class="partner-card-container" data-aos="fade-up">
                <div data-aos="fade-down">
                    <div class="partner-card">
                        <div class="image-container">
                            <img src="<?php echo e(asset('images/instragram-img.png')); ?>" alt="instragram-img" class="partner-img">
                        </div>
                    </div>
                </div>
                <div data-aos="fade-down">
                    <div class="partner-card">
                        <div class="image-container">
                            <img src="<?php echo e(asset('images/facebook-img.png')); ?>" alt="facebook-img.png-img" class="partner-img">
                        </div>
                    </div>
                </div>
                <div data-aos="fade-down">
                    <div class="partner-card">
                        <div class="image-container">
                            <img src="<?php echo e(asset('images/youtube-img.png')); ?>" alt="youtube-img.png-img" class="partner-img">
                        </div>
                    </div>
                </div>
                <div data-aos="fade-down">
                    <div class="partner-card">
                        <div class="image-container">
                            <img src="<?php echo e(asset('images/twitter-img.png')); ?>" alt="twitter-img" class="partner-img">
                        </div>
                    </div>
                </div>
                <div data-aos="fade-down">
                    <div class="partner-card">
                        <div class="image-container">
                            <img src="<?php echo e(asset('images/twitter-img.png')); ?>" alt="google-ads-img" class="partner-img">
                        </div>
                    </div>
                </div>
                <div data-aos="fade-down">
                    <div class="partner-card">
                        <div class="image-container">
                            <img src="<?php echo e(asset('images/tiktok-img.png')); ?>" alt="tiktok-img.png-img" class="partner-img">
                        </div>
                    </div>
                </div>
                <div data-aos="fade-down">
                    <div class="partner-card">
                        <div class="image-container">
                            <img src="<?php echo e(asset('images/yahoo-img.png')); ?>" alt="yahoo-img.png-img" class="partner-img">
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </main>


    <footer class="footer">
        <div class="footer-blur-1" data-aos="fade-up"></div>
        <img src="<?php echo e(asset('images/footer-coin-img.png')); ?>" alt="footer-coin-img" class="footer-coin-img">
        <div class="footer-blur-2" data-aos="fade-up"></div>
        <!--<div class="section-heading text-center" data-aos="fade-up">Don't Miss Out, Stay Updated</div>-->
        <!--<p class="section-para footer-para" data-aos="fade-up">Lorem Ipsum is simply dummy text of the printing and-->
        <!--    typesetting industry-->
        <!--    orem Ipsum has been the industry<span>'</span>s standard dummy text ever since the 1500s.</p>-->

        <!--<div class="input-container" data-aos="fade-up">-->
        <!--    <input type="email" placeholder="Enter Email Address" class="footer-input">-->
        <!--    <button class="subscribe-bnt">Subscribe Now</button>-->
        <!--</div>-->

        

        <div class="google-play-container footer-google-play-container">
            
        </div>


        <a href="<?php echo e(route('main')); ?>" class="footer-company-logo">
            <img src="<?php echo e(asset('images/nav_logo.png')); ?>" alt="nav_logo" class="footer-logo">
        </a>

        <div class="copy-right-text">
            Copyright © 2024 Infinite. All Rights Reserved. <br>
            <a href="#">Terms of use</a> <span>|</span> <a href="#">Cookies Policy</a> <span>|</span> <a href="<?php echo e(route('web.help')); ?>">Help Center</a>
        </div>
    </footer>

    <!-- Bootstrap JavaScript CDN -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
        integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r"
        crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.min.js"
        integrity="sha384-Rx+T1VzGupg4BHQYs2gCW9It+akI2MM/mndMCy36UVfodzcJcF0GGLxZIzObiEfa"
        crossorigin="anonymous"></script>

    <!-- AOS Animation JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js"
        integrity="sha512-A7AYk1fGKX6S2SsHywmPkrnzTZHrgiVT7GcQkLGDe2ev0aWb8zejytzS8wjo7PGEXKqJOrjQ4oORtnimIRZBtw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <!-- Custom JavaScript -->
    <script src="<?php echo e(asset('js/javascript.js')); ?>"></script>
</body>

</html><?php /**PATH D:\laragon\www\portal\resources\views\web\index.blade.php ENDPATH**/ ?>